

;;RECOMPILE BASE512.asm for the cube..and parse frames as a pointer, then
;;can have COMPLETE loop........maybe 1000fps? :)

ideal
p486
model   flat,c
smart


      ;basic stuff
            global  DPMIinfoNAB_   :proc
            global  DPMIintr_      :proc

dataseg

x dw 0
y dw 0

codeseg



;            Function  0400h   returns  the   version  of  DPMI  services
;            supported.  Note that this is not necessarily the version of
;            any operating  system that supports DPMI.  It should be used
;            by programs to determine what calls are legal in the current
;            environment.
;
;            Returns
;
;                 AH = Major version
;                 AL = Minor version
;                 BX = Flags
;                      Bit  0   =  1  if  running  under  an  80386  DPMI
;                      implementation
;                      Bit 1  = 1  if  processor is returned to real mode
;                      for reflected  interrupts (as  opposed to  Virtual
;                      8086 mode).
;                      Bit 2 = 1 if virtual memory is supported
;                      Bit 3 is reserved and undefined
;                      All other bits are zero and reserved for later use
;                 CL = Processor type
;                      02 = 80286
;                      03 = 80386
;                      04 = 80486
;
;
;DPMIinfo is a datastructure:1byte = Major version
;                            1byte = Minor version
;                            1byte = 1 if running under a 80386 DPMI implementation
;                            1byte = 1 if virtual memory supported
;                            1byte = processor type(2=286,3=386,4=486,5=?
;
proc DPMIinfoNAB_ DPMIinfo:dword
    pushad

    mov ax,0400h
    int 31h

    mov   edi   , [DPMIinfo]
    mov   [edi] , ah          ;Major version
    inc   edi
    mov   [edi] , al          ;Minor version
    inc   edi
    mov   dl    , bl
    and   dl    , 00000001b
    mov   [edi] , dl          ;running under 386 DPMI impl?(0/1)
    inc   edi
    mov   dl    , bl
    and   dl    , 00000010b
    shr   dl    , 1
    mov   [edi] , dl          ;virtual mem support?(0/1)
    inc   edi
    mov   [edi] , cl          ;processor type

    popad
    ret
endp DPMIinfoNAB_













;             11.1 Simulate Real Mode Interrupt
;
;
;                 This function  simulates an interrupt in real mode.  It
;                 will invoke  the  CS:IP  specified  by  the  real  mode
;                 interrupt  vector   and  the  handler  must  return  by
;                 executing an iret.
;
;            To Call
;
;                 AX = 0300h
;                 BL = Interrupt number
;                 BH = Flags
;                      Bit 0  = 1 resets the interrupt controller and A20
;                      line
;                      Other flags reserved and must be 0
;                 CX =  Number of  words to  copy from  protected mode to
;                      real mode stack
;                 ES:(E)DI = Selector:Offset of real mode call structure
;
;            Returns
;
;                 If function was successful:
;                 Carry flag is clear.
;                 ES:(E)DI =  Selector:Offset of  modified real mode call
;                      structure
;
;                 If function was not successful:
;                 Carry flag is set.
; 






proc DPMIintr_ intrnum:byte,dpmiregs:dword
    pushad

    push es ds
    mov eax,00000300h
    xor ebx,ebx
    xor ecx,ecx
    mov bl,[intrnum]
    mov edi,[dpmiregs]
    add edi,44
    mov [edi],ecx
    sub edi,44
;    int 31h

    pop ds es
    popad
    ret
endp DPMIintr_












;                 16. PHYSICAL ADDRESS MAPPING
;
;            Memory mapped  devices such as network adapters and displays
;            sometimes have  memory mapped at physical addresses that lie
;            outside of  the normal  1Mb of memory that is addressable in
;            real  mode.     Under  many  implementations  of  DPMI,  all
;            addresses are  linear addresses  since they  use the  paging
;            mechanism of  the 80386.  This service can be used by device
;            drivers to convert a physical address into a linear address.
;            The linear  address can  then be  used to  access the device
;            memory.
;
;            Some implementations  of DPMI  may  not  support  this  call
;            because it  could be  used to  circumvent system protection.
;            This call  should only  be used  by programs that absolutely
;            require direct access to a memory mapped device.
;
;            To Call
;
;                 AX = 0800h
;                 BX:CX = Physical address of memory
;                 SI:DI = Size of region to map in bytes
;
;            Returns
;
;                 If function was successful:
;                 Carry flag is clear.
;                 BX:CX =  Linear address  that can be used to access the
;                      physical memory
;
;                 If function was not successful:
;                 Carry flag is set.


end
