#include <i86.h>
#include "mouse.h"



mice::mice(void)
{
   x=0;  
   y=0; 
   button_left=up;
   button_middle=up;
   button_right=up;
}


mice::mice(long xx,long yy)
{
   x=xx;  
   y=yy; 
}



void mice::update()
{
  union REGS inregs, outregs;

  inregs.w.ax = 3;
  int386(0x33, &inregs, &outregs);
  button_left=(outregs.w.bx) & 1;             //bit1 of BX=left button
  button_right=((outregs.w.bx) & 2) >> 1;     //bit2 of BX=right button
  button_middle=((outregs.w.bx) & 4) >> 2;    //bit3 of BX=middle button

  inregs.w.ax = 11;
  int386(0x33, &inregs, &outregs);
  xinc=outregs.w.cx;
  yinc=outregs.w.dx;
  x=x+xinc;
  y=y+yinc;
  if (x<0) x=0;
  if (y<0) y=0;
  if (x>640) x=640;
  if (y>480) y=480;
}


