#ifndef THREED_H
#define THREED_H


const float DEG_CONST=3.141592654/180;
long sintab[360];
long costab[360];
long xdeg,ydeg,zdeg;
long xoffs,yoffs,zoffs;
long xrot,yrot,zrot;
long rotfin_x,rotfin_y,rotfin_z;

void maketabs()
{
long loop;
for (loop=0; loop<360; loop++)
   sintab[loop]=(sin(loop*DEG_CONST))*32768;
for (loop=0; loop<360; loop++)
   costab[loop]=(cos(loop*DEG_CONST))*32768;
}





void rotation_3d(int px,int py,int pz)
{

  long xx,yy,zz,xt,yt,zt,x,y,z;
  long xangle,yangle,zangle;
  
  if (xdeg<0) xdeg=xdeg+360;
  if (ydeg<0) ydeg=ydeg+360;
  if (zdeg<0) zdeg=zdeg+360;
  if (xdeg>359) xdeg=xdeg-360;
  if (ydeg>359) ydeg=ydeg-360;
  if (zdeg>359) zdeg=zdeg-360;

  xangle = xdeg;
  yangle = ydeg;
  zangle = zdeg;

long newx,newy,newz,oldx,oldy,oldz;

   oldx=px-xrot;
   oldy=py-yrot;
   oldz=pz-zrot;

      newy=(oldy*(costab[xangle]))-(oldz*(sintab[xangle]));
      newz=(oldz*(costab[xangle]))+(oldy*(sintab[xangle]));
      oldy=newy>>15;
      oldz=newz>>15;

      newx=((oldx*costab[yangle]))-((oldz*sintab[yangle]));
      newz=((oldz*costab[yangle]))+((oldx*sintab[yangle]));
      oldz=newz>>15;
      oldx=newx>>15;

      newx=((oldx*costab[zangle]))-((oldy*sintab[zangle]));
      newy=((oldy*costab[zangle]))+((oldx*sintab[zangle]));
      oldx=newx>>15;
      oldy=newy>>15;
           
  x=oldx+xrot+xoffs;
  y=oldy+yrot+yoffs;
  z=oldz+zrot+zoffs;

  if ((z+256)!=0) xx=(((x-xrot)*256)/(z+256))+xrot;
  if ((z+256)!=0) yy=(((y-yrot)*256)/(z+256))+yrot;

  rotfin_x=xx;
  rotfin_y=yy;
  rotfin_z=z;
}





#endif