/*****************************************

	Debug module
	code: [pK^Solstice]

*******************************************/

#include <math.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <commctrl.h>
#include <mmsystem.h>
#include <shellapi.h>
#include <commdlg.h>

FILE *DDEBUG_FilePtr;
bool DDEBUG_READY;

char DDEBUG_TEXT[1024];

bool DDEBUG_Init();
void DDEBUG_Close();

void DDEBUG_Write(const char *strString, ...)
{	

	char		strText[256];
	va_list		argumentPtr;

	if ( (DDEBUG_FilePtr == NULL) || (DDEBUG_READY == false) ) { return; }

	if (strString == NULL) { return; }
	
	va_start(argumentPtr, strString);
	vsprintf(strText, strString, argumentPtr);
	va_end(argumentPtr);

	
	fprintf(DDEBUG_FilePtr, "%s\n", strText);	
	fflush(DDEBUG_FilePtr);
	

}

bool DDEBUG_Init()
{	

	DDEBUG_FilePtr = fopen("tool.log", "w+");

	if ( DDEBUG_FilePtr == NULL ) { DDEBUG_READY = false; return false; }

	DDEBUG_READY = true; // Done

	fseek(DDEBUG_FilePtr, 0L, SEEK_END);

	if (ftell(DDEBUG_FilePtr) == 0)
	{

		DDEBUG_Write("Intro Generation Tool debug file\n\n");

	}

	return true;

}

void DDEBUG_Close()
{	

	if (DDEBUG_FilePtr != NULL)
	{	
		DDEBUG_Write("\nDebug session closed\n");
		DDEBUG_READY = false;
	}
}

