void initProjFor2D();
void initProjFor3D();
// used with opengl font system
//#define XmaxGL   0.5f * ((float)res_x/res_y)
/*
#define XmaxGL   0.375f
#define XminGL	 0.543f
#define YminGL   0.405f
#define YmaxGL   0.328f
*/
#define XLetterSizeGL 32.0f / 640
#define YLetterSizeGL 32.0f / 480

class printToScreen
{
public:;
	bool valid;
	ULONG *imgFontPix;
	long imgFontX, imgFontY;
	long *offsetImage;
	USHORT *xLetter, *yLetter;
	MyString daText;

//	opengl members:
	long	*opengl_text_numbers;
	void	**opengl_font_textures;
	float	posTextX_GL, posTextY_GL, lineHeight_GL;
//	-------end of opengl members-------

	printToScreen ( char *fontFile, char *letterOrder) 
	{
		if( (appFlags & AF_DEBUG) == 0) return;
		valid = true;
		fileOperations daFont(fontFile, valid);
		if( !daFont.checkExtension("pcx")) valid = false;
		if( !valid ) return;	// no font available

//		load font
		pcx lPCX;
		if( !lPCX.read_pcx(NULL, daFont.qloadfile(), daFont.getfilesize(), "1,0"))
		{
			valid = false;
			return;
		}
		imgFontPix = (ULONG*)lPCX.img32Bpp;
		imgFontX = lPCX.ximg;
		imgFontY = lPCX.yimg;
//		---------

		long lenghtLOrder = 0;
		while( letterOrder[lenghtLOrder] != 0) lenghtLOrder++;
//the letterOrder variable represent the letter order as they appears in the image
//ex:  "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679.;/?*()"

		offsetImage = new long[256];	// ascii code represent 256 characters
		xLetter = new USHORT[256];
		yLetter = new USHORT[256];

		int i;
		for(i=0;i<256;i++) xLetter[i] = 0;
		for(i=0;i<256;i++) yLetter[i] = 0;

//* ---------- GO THREW THE IMAGE AND KEEP THE OFFSET AND SIZE OF EACH LETTER ------*
		int walkerX = 0, walkerY=0;	// walkerY is absolute
		int lastX=0, lastY=0;
		int cLetter = 0;
		bool found= false;
		while(walkerY<imgFontY)
		{
			while( ((walkerY++) < (imgFontY-1)) && (imgFontPix[(walkerY*imgFontX)]!=0x0000ffff) );
			walkerX = 0;
			lastX = 0;
			while( walkerX < imgFontX )
			{
				if( imgFontPix[(lastY*imgFontX)+walkerX]==0x0000ffff )
				{
					found = true;
					offsetImage[letterOrder[cLetter]] = (lastY*imgFontX) + lastX+1;
					xLetter[letterOrder[cLetter]] = walkerX - lastX-1;
					yLetter[letterOrder[cLetter]] = walkerY - lastY;
					lastX = walkerX;
					cLetter++;
					if(cLetter> lenghtLOrder)
					{
						quitMessage("Scrolling constructor", "Algo error, exiting");
						return;
					}
				}
 				walkerX++;
			}
			lastY = walkerY+1;
		}
		if(found == false)
		{
		 warningMessage("The image font is not compatible :(","printToScreen constructor");
		 valid = false;
		}


// now init opengl
		lineHeight_GL = YLetterSizeGL;
		posTextX_GL = - 1;
		posTextY_GL = 1;

		// init textures...
		opengl_text_numbers = new long[256];
		opengl_font_textures = new void*[256];
		for(long e=0;e<256;e++)
		{
			opengl_font_textures[e] =  new long[32*32];
			for( int r=0;r<32*32;r++) ((ULONG**)opengl_font_textures)[e][r] = 0;
			writeLetter_GLInit(0, 0, (UCHAR)e, opengl_font_textures[e]);
		}
	}


	void clear()
	{
		if( (appFlags & AF_DEBUG) == 0) return;
		if( !valid) return;
		daText.clear();
		posTextX_GL = -1;
		posTextY_GL = 1;
	}

	void addText(char *text)
	{
		if( (appFlags & AF_DEBUG) == 0) return;
		if( !valid) return;
		daText += text;
	}

	void printText()
	{
		if( (appFlags & AF_DEBUG) == 0) return;
		if( !valid) return;
		char *text = daText.data;
		long i=0;
		while( text[i] != 0)
		{
			if(text[i] == 10) 
			{
				posTextX_GL = -1;
				posTextY_GL -= lineHeight_GL;
				i++;
				if( (i+1)>= daText.size ) return;
			}
			writeLetter_GL(posTextX_GL, posTextY_GL, text[i]);

			posTextX_GL += 32.0f / 640;
			i++;
		}
	}

//	write letter pixels in a texture memory used by opengl
	void writeLetter_GLInit(int xpos, int ypos, UCHAR cText, void *VirtualScreen)
	{
		if( !valid) return;
		int beginY=0;
		int endY=yLetter[cText];
		long maxx = 32;
		long maxy = 32;
//		clip ...
		if(ypos < 0) { beginY = -ypos; ypos = 0; }
		else if( (ypos + endY) >= maxy ) endY -= (endY+ypos) -maxy;
		// clipping: for debugging purposes...
		if( (xpos + xLetter[cText])>= maxx) return;
		if(xpos<0) return;
		int addLign = imgFontX - xLetter[cText];
		int addVideo = maxx - xLetter[cText];
		int oVideo = (ypos*maxx)+xpos, oImgFont= offsetImage[cText] + (beginY*imgFontX);

		for(int i=beginY; i<endY;i++)
		{
			for(int j=0;j<xLetter[cText];j++)
			{
				((ULONG*)VirtualScreen)[oVideo] = imgFontPix[oImgFont];
				oVideo++;
				oImgFont++;
			}
			oVideo += addVideo;
			oImgFont += addLign;
		}
	}

	void writeLetter_GL(float xpos, float ypos, char cText)
	{
		initProjFor2D();

		glBindTexture(GL_TEXTURE_2D, GLtexture[opengl_text_numbers[cText]]);
#define sizeX  XLetterSizeGL
#define sizeY  YLetterSizeGL

		glLoadIdentity();		// current matrix should be MODEL_MATRIX
		glColor4f( 1, 1, 1, 1);
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glBegin(GL_QUADS);
		glTexCoord2f( 0, 0);
		glVertex3f( xpos , ypos ,-1);
		glTexCoord2f( 1, 0);
		glVertex3f( xpos + sizeX, ypos ,-1);
		glTexCoord2f( 1, 1);
		glVertex3f( xpos + sizeX, ypos -sizeY ,-1);
		glTexCoord2f( 0, 1);
		glVertex3f( xpos , ypos -sizeY,-1);
		glEnd();
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
		initProjFor3D();
	}
};

class printToScreen *debugPrint = NULL;