#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <GL/glut.h>
#include <signal.h>

#include "addJpeg.c"

#define PLATFORM_LINUX

#include "Attila.cpp"
#include "sound.c"

int pid;

void display(void){
	glutSwapBuffers();			// opengl swap
}

void
animate(void)
{
	// start deugging info here
	if( (appFlags & AF_DEBUG) != 0) debugPrint->clear();
	if ( scnMan.playList() )
	{
		kill(pid,SIGKILL);	// kill sound process
		releaseScenes();
		exit(0);
	}
	if( appFlags & AF_RENDERING ) glutPostRedisplay();
}

void
visible(int state)
{
  if( state == GLUT_VISIBLE ) appFlags |= AF_RENDERING;
  else appFlags &= ~AF_RENDERING;
  glutIdleFunc(animate);
}

void initDemo()
{
	demoMode = true;
	strcpy( musicname, "d:\\gozervrac\\dimension3\\Ay_chang.mo3");
					
	long  o;
#define nscenes  10
	char sceneName[nscenes][256];
	strcpy( sceneName[0] , "d:\\gozervrac\\dimension3\\scenes\\spacecube\\spacecube.lws");
	strcpy( sceneName[1] , "d:\\gozervrac\\dimension3\\scenes\\nipotkoi.lws");
	strcpy( sceneName[2] , "D:\\GozerVrac\\Dimension3\\scenes\\SPACE_BUILDING\\temp.lws");
	strcpy( sceneName[3] , "D:\\GozerVrac\\Dimension3\\scenes\\manu\\scenes\\atome.lws");
	strcpy( sceneName[4] , "D:\\GozerVrac\\Dimension3\\scenes\\manu\\manu2\\scenes\\base\\base2.lws");
	strcpy( sceneName[5] , "D:\\GozerVrac\\Dimension3\\scenes\\pyramidMirror\\pyramidMirrorScene2.lws");
	strcpy( sceneName[6] , "D:\\GozerVrac\\Dimension3\\scenes\\manu\\manu2\\scenes\\Palais DBZ\\dbz2.lws");
	strcpy( sceneName[7] , "D:\\GozerVrac\\Dimension3\\scenes\\trees\\trees.lws");
	strcpy( sceneName[8] , "D:\\GozerVrac\\Dimension3\\scenes\\circles\\circleOne.lws");
	strcpy( sceneName[9] , "D:\\GozerVrac\\Dimension3\\scenes\\EndScene\\ende.lws");
	for(o=0;o<nscenes;o++) scnMan.add( sceneName[o] );

	if(scene != NULL) quitMessage("dialog PRoc","Error Managing memory, leak on scene!!!! :(");
	scene = new scen[scnMan.nbs];
					
	// create temporary dialog box for waiting advice
	for(long i=0;i<scnMan.nbs;i++) scene[i].loadScene(scnMan.filenames[i]);
	appFlags |= AF_RENDERING;
	scnMan.initAll4Play();
	// no need to keep names of objects, surfaces...
	scnMan.deleteAllNames();

	initTexturesGL();
	// 2D effect init
	videoEffect.startTime = MyGetTickCount();
	videoEffect.videoBuffer = videoGL;
	videoEffect.Init_Textures();
	videoEffect.Init_Tunnel(0);
	videoEffect.CalculateFlower();

  	scene[0].init4Play();	// init first scene...

	fileOperations sndFile("C:\\trash\\sics\\Ay_chang.it");
	void *sndBuff = sndFile.qloadfile();
	My_init_sound(sndBuff, sndFile.getfilesize());
	delete sndBuff;
}

void
keyboard(unsigned char ch, int x, int y)
{
  switch (ch) {
  case 27:             /* ESC */
    kill(pid,SIGKILL);	// kill sound process
    releaseScenes();
    exit(0);
    break;
  }
}

void doFree()
{
    kill(pid,SIGKILL);	// kill sound process
    My_release_sound();
    releaseScenes();
}

int main(int argc, char **argv)
{
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGBA);
	glutInitWindowPosition(5,5);
	glutInitWindowSize(640,480);
	glutCreateWindow("Space delirium");
	glutDisplayFunc(display);
	glutKeyboardFunc(keyboard);
	glutVisibilityFunc(visible);
	glViewport(0,0,640,480);
	initDemo();
	atexit(doFree);
	if (pid=fork())
	{
//	parent process
		glutMainLoop();
	}
// child process
	else
	{
		My_childThread();
		My_release_sound();
	}
	return 0;
}

