#include "GL/gl.h"

#include "boxscreffect.h"
#include "geareffect.h"
#include "miscrender.h"
#include "textview.h"

#define TIMEOUT_TEXT1	( 60 )
#define TIMEOUT_TEXT2	( TIMEOUT_TEXT1 + 30 )
#define TIMEOUT_CLEAR	( TIMEOUT_TEXT2 + 160 )
#define TIMEOUT_END	( TIMEOUT_CLEAR + 20 )
////////

BoxScrEffect::BoxScrEffect():
	myCamAngle( 0 ), myCamTilt( 90.f ), myAngle( 0 ),
	myTimeoutCount( -99999 ),
	myEndMove( false )
{
	glClearColor( 0.01f, 0.01f, 0.08f, 0.0f );
	initLight( 0,   0, 0, -10,   56, 190, 250 );

	textviewClear();
}

BoxScrEffect::~BoxScrEffect()
{
}

// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
Effect *BoxScrEffect::update()
{
	myCamAngle += 0.3f;
	myAngle += 2.f;

	// Next effect?
	switch ( myTimeoutCount++ )
	{
	case TIMEOUT_TEXT1:
		textviewWrite( "aaltokuviot on in", 20, 20, 4 );
		break;

	case TIMEOUT_TEXT2:
		{
			const char *text = "waves are hot";
			textviewWrite( text, 620 - textviewWidth( text, 3 ), 460 - textviewHeight( text, 3 ), 3 );
		}
		break;
	
	case TIMEOUT_CLEAR:
		textviewClear();
		break;
	
	case TIMEOUT_END:
		myEndMove = true;
		break;
	}

	// End move?
	if ( myEndMove )
	{
		myCamTilt += 0.8f;
		if ( myCamTilt > 90.f )
			return new GearEffect();
	}
	else
	{ // Possibly starting
		myCamTilt -= 1.f;
		if ( myCamTilt < 0.f )
		{
			myCamTilt = 0.f;
			glClearColor( 0.1f, 0.05f, 0.15f, 0.0f );

			// Reset the timeout to start from here (if not)
			if ( myTimeoutCount < 0 )
				myTimeoutCount = 0;
		}
	}

	return this;
}

// Renders the effects current frame
void BoxScrEffect::render()
{
	glEnable( GL_LIGHTING );

	// Camera setup
	glRotatef( -myCamTilt, 1, 0, 0 );
	glRotatef( myCamAngle, 0, 0, 1 );

	// Draw the boxes
	const float bound = 10.f;
	const float step = 1.f;

	for ( float y = -bound; y <= bound; y += step )
	{
		for ( float x = -bound; x <= bound; x += step )
		{
			float angle = myAngle + ( x * 5 ) + ( y * 8 );

			glPushMatrix();
			glTranslatef( x, y, -16.f );
			glRotatef( angle, 1, 0, 0 );
			glRotatef( angle, 0, 1, 0 );
			drawBox();
			glPopMatrix();
		}
	}
}
