#include "GL/gl.h"

#include "effect.h"

Effect::Effect()
{
	glClearColor( 0.f, 0.f, 0.f, 0.0f );

	glDisable( GL_LIGHTING );
	glDisable( GL_LIGHT0 );
	glDisable( GL_LIGHT1 );
	glDisable( GL_LIGHT2 );
	glDisable( GL_LIGHT3 );
}

Effect::~Effect()
{
}

// Inits a given light
void Effect::initLight( int lNum,  float x, float y, float z, int r, int g, int b, int sr, int sg, int sb )
{
#define C( val ) ( ( ( float ) ( val ) ) / 255.f )

	int light = GL_LIGHT0 + lNum;

	GLfloat ambient[] = { 0.1, 0.1, 0.1, 1.0 };
	GLfloat diffuse[] = { C( r ), C( g ), C( b ), 0 };
	GLfloat specular[] = { C( sr ), C( sg ), C( sb ), 0 };

	glEnable( GL_LIGHTING );
	glEnable( light );

	glLightfv( light, GL_AMBIENT, ambient );
	glLightfv( light, GL_DIFFUSE, diffuse );
	glLightfv( light, GL_SPECULAR, specular );

//	glLightf( light, GL_CONSTANT_ATTENUATION, 0.0f );
//	glLightf( light, GL_LINEAR_ATTENUATION, 0.005f );
//	glLightf( light, GL_QUADRATIC_ATTENUATION, 0.0f );

#undef C
}

// Sets the material
void Effect::setMaterial( int r, int g, int b )
{
#define C( val ) ( ( ( float ) ( val ) ) / 255.f )

	GLfloat diffuse[] = { C( r ), C( g ), C( b ), 1.f };

	glMaterialfv( GL_FRONT, GL_DIFFUSE, diffuse );

#undef C
}
