// Abstract effect definition
#ifndef __EFFECT_H
#define __EFFECT_H

class Effect
{
public:
	Effect();
	virtual ~Effect() = 0;

	// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
	virtual Effect *update() = 0;

	// Renders the effects current frame
	virtual void render() = 0;

protected:
	// Inits a given light
	virtual void initLight( int lNum,  float x, float y, float z, int r = 255, int g = 255, int b = 255, int sr = 0, int sg = 0, int sb = 0 );

	// Sets the material
	virtual void setMaterial( int r, int g, int b );
};

#endif
