#include <math.h>
#include "GL/gl.h"

#include "endfadeeffect.h"
#include "textview.h"

#define MAX_XRADIUS	500
#define MAX_YRADIUS	350

#define TEXT		"isk oon tlls!"
#define TEXT_ZOOM	4
#define TEXT2		"mom, i'm on tv!"
#define TEXT2_ZOOM	3

#define TIMEOUT_TEXT	0
#define TIMEOUT_BALL	( TIMEOUT_TEXT + 200 )

#define QUIT_RADIUS -40

EndFadeEffect::EndFadeEffect():
	myBallSize( MAX_XRADIUS - 1 ),
	myTextX( 0 ), myTextY( -100 ),
	myText2X( 0 ), myText2Y( -100 ),
	myTimeout( 0 )
{
	textviewClear();

	glClearColor( 0.3f, 0.3f, 0.4f, 0.0f );
	initLight( 0,   0, 0, -5,   0, 0, 0 );
}

EndFadeEffect::~EndFadeEffect()
{
}

// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
Effect *EndFadeEffect::update()
{
	// Timeouts
	switch ( myTimeout++ )
	{
	case TIMEOUT_TEXT:
		{
			myTextX = ( 640 - textviewWidth( TEXT, TEXT_ZOOM ) ) / 2;
			myTextY = ( 480 - textviewHeight( TEXT, TEXT_ZOOM ) ) / 2;

			myText2X = ( 640 - textviewWidth( TEXT2, TEXT2_ZOOM ) ) / 2;
			myText2Y = myTextY + textviewHeight( TEXT, TEXT_ZOOM );
		}
		break;
	}

	// Closing the ball?
	if ( myTimeout >= TIMEOUT_BALL )
	{
		myBallSize -= 1;
		if ( myBallSize < QUIT_RADIUS )
			return 0;
	}

	return this;
}

// Renders the effects current frame
void EndFadeEffect::render()
{
	// Write the text
	textviewRender( TEXT, myTextX, myTextY, TEXT_ZOOM );
	textviewRender( TEXT2, myText2X, myText2Y, TEXT2_ZOOM );

	glEnable( GL_LIGHTING );

	// Init the camera
	glMatrixMode( GL_PROJECTION );
	glPushMatrix();
	glLoadIdentity();
	glOrtho( 0, 639, 479, 0, 0, 10 );

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	glTranslatef( 320, 240, 0 );

	// Draw the circle
	glBegin( GL_TRIANGLE_STRIP );

	float radius = ( myBallSize > 0 ) ? myBallSize : 0;

	for ( int i = 0; i < 360; ++i )
	{
		int iNext = ( i + 1 ) % 360;

		if ( i == 0 )
		{ // Two first vertices
			float ang = i * 3.1415926f / 180.f;
			glVertex3f( cosf( ang ) * radius, sinf( ang ) * radius, -1 );
			glVertex3f( cosf( ang ) * MAX_XRADIUS, sinf( ang ) * MAX_YRADIUS, -1 );
		}

		float angNext = iNext * 3.1415926f / 180.f;
		glVertex3f( cosf( angNext ) * radius, sinf( angNext ) * radius, -1 );
		glVertex3f( cosf( angNext ) * MAX_XRADIUS, sinf( angNext ) * MAX_YRADIUS, -1 );
	}

	glEnd();

	// Done
	glMatrixMode( GL_PROJECTION );
	glPopMatrix();
}
