// Gear effect
#ifndef __GEAREFFECT_H
#define __GEAREFFECT_H
#include "effect.h"

class GearEffect : public Effect
{
public:
	GearEffect();
	virtual ~GearEffect();

	// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
	virtual Effect *update();

	// Renders the effects current frame
	virtual void render();

private:
	// The gear display list
	int myGearDisplayList;

	// The gear angle
	float myGearPosY;
	float myGearDist;
	float myGearAngle;

	// Text show timeout
	int myTextShowTimeout;
	// The timeout counter
	int myTimeoutCount;


	// Creates the gear
	void createGear();
};

#endif
