// Pipe effect
#ifndef __PIPEEFFECT_H
#define __PIPEEFFECT_H
#include "effect.h"

class PipeEffect : public Effect
{
public:
	PipeEffect();
	virtual ~PipeEffect();

	// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
	virtual Effect *update();

	// Renders the effects current frame
	virtual void render();

private:
	// The pipe display list
	int myPipeDisplayList;
	// The pipe height
	float myPipeDist;
	float myPipeHeight;

	// The timeout counter
	int myTimeout;
	// Leaving?
	bool myLeaving;

	// The pipe angle
	float myAngle;
	// The pipe position [-myPipeHeight/2,myPipeHeight/2]
	float myPipePos;


	// Creates the pipe
	void createPipe();
};

#endif
