// Starting credits
#ifndef __TAATEFFECT_H
#define __TAATEFFECT_H
#include <vector>
#include "effect.h"

class TaatEffect : public Effect
{
public:
	TaatEffect();
	virtual ~TaatEffect();

	// Updates the effect for one frame (returns the next effect; 0 (quit), this (continue) or a new effect)
	virtual Effect *update();

	// Renders the effects current frame
	virtual void render();

private:
	class Box
	{
	public:
		int texId;
		float x, y;
		float vx, vy;
		float ang;
		float angAdd;

		bool deleted;

		Box(): deleted( false ) { }
	};

	typedef std::vector< Box > BoxList;

	enum State {
		State_Start,
		State_Wait,
		State_Taat1,
		State_Taat2,
		State_TaatWait1,
		State_TaatWait2,
		State_Logo1,
		State_Logo1b,
		State_Logo2,
		State_Logo2b,
		State_EndStart,
		State_EndWait,
	};

	// Current state
	State myState;

	// Current state pause
	int myStatePause;

	// List of remaining boxes
	int myBoxesLeft;
	// Lift of box add pause
	int myBoxPause;
	// List of boxes
	BoxList myBoxes;
};

#endif
