#version 330

in vec2 uv;
in vec2 uvasp;
out vec4 FragColor;

uniform sampler2D tex;
uniform vec4 basecolor;
uniform float screensize;
uniform float tick;

void main()
{	
	vec2 screenpos = uv * screensize;	
	vec4 tex = texture(tex, vec2((screenpos.x-(screensize - 256)/2)/256.0,(screenpos.y + tick * 0.04 - 1024)/4096.0) );
	FragColor = tex;
	if (screenpos.x < (screensize - 256)/2 ||
	    screenpos.x > (screensize + 256)/2)
	    FragColor = vec4(0);
}