#version 330
#extension GL_ARB_explicit_uniform_location : enable

in vec2 uv;
out vec4 fragcolor;
uniform sampler2D tex;
uniform bool horizontal;
float weight[9] = float[] (0.102934, 0.099783, 0.090898, 0.077812, 0.062595, 0.047318, 0.033613, 0.022439, 0.014076);
// (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

void main ()
{
    vec2 tex_offset = 1.0 / textureSize(tex, 0);
    vec3 res = texture(tex, uv).xyz * weight[0];
    if(horizontal)
    {
        for(int i = 1; i < 9; i++)
        {
            res += texture(tex, uv + vec2(tex_offset.x * i, 0.0)).xyz * weight[i];
            res += texture(tex, uv - vec2(tex_offset.x * i, 0.0)).xyz * weight[i];
        }
    }
    else
    {
        for(int i = 1; i < 9; i++)
        {
            res += texture(tex, uv + vec2(0.0, tex_offset.y * i)).xyz * weight[i];
            res += texture(tex, uv - vec2(0.0, tex_offset.y * i)).xyz * weight[i];
        }
    }
    fragcolor = vec4(res, 1);
}