#version 330
#extension GL_ARB_explicit_uniform_location : enable

in vec2 uv;
out vec4 fragcolor;

vec3 marble_color (float x)
{
    vec3 col;
    x = 0.5*(x+1.);        
    x = sqrt(x);           
    x = sqrt(x);
    col = vec3(.2 + .75*x);
    col.b*=0.95;             

    col = vec3(1,1,1) - col;
    col = mix(col, vec3(0.2,0.2,0.2), 0.75);
    
    return col;
}

float rand(float n){return fract(sin(n) * 43758.5453123);}
float rand(vec2 n) { 
	return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}
float noise(float p){
	float fl = floor(p);
  float fc = fract(p);
	return mix(rand(fl), rand(fl + 1.0), fc);
}
	
float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
  vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return mix(mix(rand(b), rand(b + d.yx), f.x), mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}

float turbulence (vec2 P, int numFreq)
   {
      float val = 0.0;
      float freq = 1.0;
      for (int i=0; i<numFreq; i++) {
         val += abs (noise(P*freq) / freq);
         freq *= 2.07;
      }
      return val;
   }  
  
  vec4 calc(vec2 uv)
  {
      float cdist = 1 - sqrt((uv.x-0.5) * (uv.x-0.5) + (uv.y-0.5)*(uv.y-0.5))/0.7;
      uv *= 3;
      float amplitude = 40.0;
      const int roughness = 7;

      float t =  6.28 * uv.x;
      t += amplitude * turbulence (uv.xy*10, roughness);
      t = sin(t);
      vec3 marbleColor = marble_color(t);
     return vec4(marbleColor,1) * cdist;
}

    void main()
    {
    fragcolor = calc(uv);
    }