///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// Text mode demo compo 5 invitation demo
// Copyright (c) 2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////
//
// Oo - and actual object in this pile!
// Rather simple printer.. thingy. Performs clipping per pixel, which
// is especially handy when we're rendering those 20-screen-wide scrollers.
// Waste of CPU power? Yes, definitely.
//
#include "..\main\pcxload.h"
#include "SimpleFontPrinter.h"
#include "blendfuncs.h"

SimpleFontPrinter::~SimpleFontPrinter()
{
    delete[] mData;
    delete[] mCharacterOffset;
    delete[] mCharacterWidth;
}

SimpleFontPrinter::SimpleFontPrinter()
{
}

SimpleFontPrinter * SimpleFontPrinter::create(char * aFontFilename)
{
    SimpleFontPrinter * sfp;
    sfp = new SimpleFontPrinter;
    char * temp = loadpcx(aFontFilename);
    char * temppal = loadpcxpal(aFontFilename);
    int t;
    getpcxinfo(aFontFilename, &sfp->mWidth, &t);
    sfp->mData = new int[sfp->mWidth * t];
    for (int i = 0; i < sfp->mWidth * t; i++)
        sfp->mData[i] = ((temppal[(temp[i]&0xff) * 3 + 0]&0xff) << 0) +
                        ((temppal[(temp[i]&0xff) * 3 + 1]&0xff) << 8) +
                        ((temppal[(temp[i]&0xff) * 3 + 0]&0xff) << 16);
    delete[] temp;
    delete[] temppal;
    t /= sfp->mWidth;
    sfp->mCharacterOffset = new int[t];
    sfp->mCharacterWidth = new int[t];
    for (int c = 0; c < t; c++)
    {
        int x1=200,x2=-1;
        for (int i = 0; i < sfp->mWidth; i++)
        {
            for (int j = 0; j < sfp->mWidth; j++)
            {
                int k = sfp->mData[i*sfp->mWidth+j+c*sfp->mWidth*sfp->mWidth]&0xff;
                if (k)
                {
                    if (x1 > j) x1 = j;
                    if (x2 < j) x2 = j;
                }
            }
        }
        sfp->mCharacterOffset[c] = x1;
        sfp->mCharacterWidth[c] = x2 - x1 + 2;
    }
    sfp->mCharacterWidth[0] = sfp->mWidth / 3;
    sfp->mCharacterOffset[0] = 0;    
    return sfp;
}

int SimpleFontPrinter::printChar(int * target, int x, int y, char ch, int mode, int value)
{
    for (int i = 0; i < mWidth; i++)
        for (int j = 0; j < mCharacterWidth[ch]; j++)
        {
            if (((x + j) > 0) && ((x + j) < 160) &&
                ((y + i) > 0) && ((y + i) < 100))
            {
                int pixval = mData[i*mWidth+j+mCharacterOffset[ch]+ch*mWidth*mWidth];            
                if (pixval)
                {
                    switch (mode)
                    {
                    case 0: // solid
                        target[i*160+j] = pixval;
                        break;
                    case 1: // additive
                        target[i*160+j] = blend_additive(target[i*160+j], pixval, value);
                        break;
                    case 2: // crossfade
                        target[i*160+j] = blend_fade(target[i*160+j], pixval, value);
                        break;
                    case 3: // invmul
                        target[i*160+j] = blend_invmul(target[i*160+j], pixval, value);
                        break;
                    }
                }
            }
        }
        return mCharacterWidth[ch];
}

void SimpleFontPrinter::print(int * target, int x, int y, char * st, int mode, int value)
{
    int o = x + y * 160;
    int xpos = x;
    while (*st)
    {
        int w = printChar(target + o, xpos, y, (char)(*st - 32), mode, value);
        o += w;
        xpos += w;
        st++;
    }
}
