///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// Text mode demo compo 5 invitation demo
// Copyright (c) 2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////
//
// 3d fun. Uses d3dx8 math. Almost the same as do3d.cpp.
//

#include <d3dx8.h>
#include <math.h>
#include "misc.h"

// from demo.cpp
extern int blendmode, blendvalue;
extern int backface(vertexuvfloat * vtx);

void do3d2(int tick, int *fb)
{
    memset(fb,0,160*100*4);

    D3DXMATRIX camera, projection, world;
    D3DXMatrixLookAtLH(&camera,&D3DXVECTOR3(0,0,-100),&D3DXVECTOR3(0,0,0),&D3DXVECTOR3(0,1,0));  
    D3DXMatrixPerspectiveFovLH(&projection, (3.14f / 360) * 90, 1.0f / 1.3f, 1, 1000);
    D3DXMatrixRotationYawPitchRoll(&world, 0, 0, tick * 0.0244f);

    D3DXMATRIX res = world;
    D3DXMatrixMultiply(&res,&res,&camera);
    D3DXMatrixMultiply(&res,&res,&projection);

    D3DXVECTOR3 src[1024];
    srand(0xc0cac01a);

    for (int i = 0; i < 1024; i++)
    {
        src[i].x = (float)((sin((i + 1) * (3.14f / 8)) * 20) * sin((tick + i) * 0.02347f));
        src[i].y = (float)((cos((i + 1) * (3.14f / 8)) * 20) * cos((tick + i) * 0.02347f));
        src[i].z = (float)(-((i + tick*2) % 1024)) * 1.0f + 900; 
    }

    D3DXVECTOR4 tgt[1024];

    for (i = 0; i < 1024; i++)
    {
        D3DXVec3Transform(&tgt[i],&src[i],&res);
        tgt[i].x = ((tgt[i].x / tgt[i].w) * 160) + 80;
        tgt[i].y = ((tgt[i].y / tgt[i].w) * 160) + 50;
    }

    // Yes, we draw 1008 triangles in weighted average mode in textmode. Pointless.
    // But looks kinda cute.
    for (i = 0; i < 1024 - 16; i+=2)
    {
        vertexuvfloat vtx[3];
        vtx[0].x = tgt[i].x;
        vtx[0].y = tgt[i].y;
        vtx[2].x = tgt[i+1].x;
        vtx[2].y = tgt[i+1].y;
        vtx[1].x = tgt[i+16].x;
        vtx[1].y = tgt[i+16].y;
        if(backface(vtx))
        {
            vertexuvfloat temp = vtx[1];
            vtx[1] = vtx[2];
            vtx[2] = temp;
        }
 
        blendmode = 2;
        blendvalue = 127;
        if (tgt[i].z > 1 && 
            tgt[i+1].z > 1 && 
            tgt[i+16].z > 1)         
        DrawFlatTriangle(vtx, ((i >> 6) & 1)?0xff1122:0x1122ff);
    }




}