/*
 * RAMFILE3 - fopen/fseek/ftell/fgetc/fread/fclose replacement to read
 *            from memory buffer.
 * Copyright 2001 Jari Komppa
 */
#ifndef RAMFILE3_H_INCLUDED
#define RAMFILE3_H_INCLUDED

typedef struct ramfile3struct {
  char * buffer;
  int offset;
  int length;
  int _flag;
} RAMFILE3;

extern RAMFILE3 * RAMfopen(char * buffer, int length);
extern RAMFILE3 * RAMfopencfl(char * fname);
extern int RAMfseek(RAMFILE3 * t, int displacement, int mode);
extern int RAMftell(RAMFILE3 * t);
extern int RAMfgetc(RAMFILE3 * t);
extern int RAMfread(void * buf, int size, int count, RAMFILE3 * t);
extern int RAMfclose(RAMFILE3 * t);
extern int RAMfclose_nofree(RAMFILE3 * t);
#endif

#ifndef RAMFILIZE
#define RAMFILIZE
#define FILE RAMFILE3
#define fseek RAMfseek
#define ftell RAMftell
#define fgetc RAMfgetc
#define fread RAMfread
#define fclose RAMfclose
#define fopen(a,b) RAMfopencfl(a)
#endif

