;
include                         font8x8.inc
include                         ascii.tbl
include                         trans.tbl
;
next_letter_delay               equ 2
initial_zoom                    equ 9
number_of_chars                 equ 49
coordx                          equ 15
;
coordy                          dw 0
d_next_letter                   db 0
d_wait                          dw 0
buffer_offset                   dw offset ascii_buffer
text_offset                     dw 0
ascii_buffer                    dw 020h dup (offset font+040h)
counters_buffer                 dw 020h dup (0)
;
zoom_efect:                     mov ax,0a898h
                                mov es,ax
                                cmp word ptr d_wait,0
                                je  not_waiting
                                dec word ptr d_wait
                                jmp redraw
not_waiting:                    cmp byte ptr d_next_letter,0
                                je get_next
                                dec byte ptr d_next_letter
                                jmp redraw
get_next:                       mov d_next_letter,next_letter_delay
                                mov bx,text_offset
retake:                         mov al,text[bx]
                                inc bx
                                cmp al,0ffh
                                je  end_of_text
                                cmp al,0feh
                                je  waitin
                                cmp al,0fdh
                                jne not_special_command
                                mov ax,word ptr text[bx]
                                mov coordy,ax
                                add bx,2
                                mov buffer_offset,offset ascii_buffer
                                jmp retake
waitin:                         mov ax,word ptr text[bx]
                                mov d_wait,ax
                                add bx,2
                                mov text_offset,bx
                                jmp redraw
end_of_text:                    mov buffer_offset,offset ascii_buffer
                                xor bx,bx
                                xor al,al
                                mov text_offset,bx ;<<<<===--- RETAKE
                                jmp mproc          ;<<<<===--- RETAKE
not_special_command:            mov text_offset,bx
                                mov si,offset ascii_in
                                mov cx,number_of_chars
searchin:                       cmp [si],al
                                jz found
                                inc si
                                loop searchin
                                mov cx,number_of_chars
found:                          mov ax,number_of_chars
                                sub ax,cx
                                xor bh,bh
                                mov bl,al
                                shl bx,1
                                mov bx,ascii_table[bx]
                                mov si,buffer_offset
                                mov [si],bx
                                add si,002h
                                mov buffer_offset,si
                                add si,040h-002h
                                mov byte ptr [si],initial_zoom
redraw:                         xor  bx,bx
                                mov  di,coordy
                                add  di,coordx
sweep_middle_mesg:              push bx
                                push di
                                mov  cx,counters_buffer[bx]
                                or   cl,cl
                                je   skip_printing
                                mov  si,ascii_buffer[bx]
                                mov  bl,cl
                                push si
                                push di
                                mov  si,offset font
                                inc  bx
                                call zoom
                                pop  di
                                pop si
                                call zoom
                                mov cl,bl
skip_printing:                  pop di
                                pop bx
                                add di,8
                                mov byte ptr counters_buffer[bx],cl
                                add bl,2
                                cmp bl,040h
                                jne sweep_middle_mesg
                                ret

zoom:                           mov ax,0320
                                mul bx           ;zoom by bx
                                mov bp,ax
                                dec bx
                                mov cx,8
zoom_:                          push di
                                rept 8
                                movsb
                                add di,bx
                                endm
                                pop di
                                add di,bp
                                loop zoom_
abort:                          ret
