#ifndef PARTICLESYSTEM

#define PARTICLESYSTEM


#include "SM_Engine3DPCH.h"
#include "SM_Renderable.h"

struct Particle
{
  Vector3D v3dStart;
  Vector3D v3dVelocity;
  Vector3D v3dAccel;
  float    fBirth;
  float    fDeath;
};

class D3DMesh;

class RenderParticleSystem : public IRenderable
{
public:
    RenderParticleSystem    ();
    ~RenderParticleSystem   ();

    int     Init                  (int iShader, D3DMesh* pAnimable);
    int     Shutdown              ();
    int     Reset                 ();

    void    Render                (RenderContext* pRenderContext, int iOutcode, float fTime);

    void    SetParams             (const char* pcParams);
    

    void    SetParticleSize       (float fSize);
    void    SetVelocity           (Vector3D& v3dVelocity);
    void    SetAcceleration       (Vector3D& v3dAccel);
    void    SetParticlesPerSecond (float fParticlesSecond);
    void    SetLifetime           (float fLifetime);
    void    SetDiscRadius         (float fDiscRadius);


    D3DMesh*  GetMesh()
    {
      return m_pAnimable;
    }

    Vector3D                m_v3dPosition;
    Quaternion              m_qRotation;
protected:
    int                    m_iShader;
    D3DMesh*               m_pAnimable;    
    MBStaticList<Particle> ParticleList;
    Vector3D               m_v3dVelocity;
    Vector3D               m_v3dAccel;
    float                  m_fLastFrame;
    float                  m_fPeriod;
    float                  m_fLifetime;
    float                  m_fSize;
    float                  m_fFadeOffset;
    float                  m_fDiscRadius;

};



#endif 