#pragma once

namespace Perlin
{
	// Standard Perlin 'optimised' noise functions
	OSCAR_API  float Noise1	(float x);
	OSCAR_API  float Noise2	(float x,float y);
	OSCAR_API  float Noise3	(float x,float y,float z);


	__inline float Noise1o	(float x, int o=2)
	{
		float f=0;
		float g=1;
		for (;o>0;o--) {f+=Noise1(x)*g;g*=0.5f;x*=2;}
		return f;
	}

	__inline float Noise2o	(float x,float y, int o=2)
	{
		float f=0;
		float g=1;
		for (;o>0;o--) {f+=Noise2(x,y)*g;g*=0.5f;x*=2;y*=2;}
		return f;
	}

	__inline float Noise3o	(float x,float y,float z, int o=2)
	{
		float f=0;
		float g=1;
		for (;o>0;o--) {f+=Noise3(x,y,z)*g;g*=0.5f;x*=2;y*=2;z*=2;}
		return f;
	}

	//to initialise the 'noise' lookup arrays
	OSCAR_API  void	PInitNoise();



}