#include "ConfigTool.h"

/*
// 3d position tool ?
if(dmsGetMouseLeft())
{
	dmsSetMouseLeft();
	float x = dmsGetMouseX();
	float y = dmsGetMouseX();

	GLint viewport[4];
	GLdouble modelview[16];
	GLdouble projection[16];
	GLfloat winX, winY, winZ;
	GLdouble posX, posY, posZ;

	glGetDoublev( GL_MODELVIEW_MATRIX, modelview );
	glGetDoublev( GL_PROJECTION_MATRIX, projection );
	glGetIntegerv( GL_VIEWPORT, viewport );

	winX = (float)x;
	winY = (float)viewport[3] - (float)y;
	glReadPixels( x, int(winY), 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &winZ );

	gluUnProject( winX, winY, winZ, modelview, projection, viewport, &posX, &posY, &posZ);

	//return CVector3(posX, posY, posZ);
	dmsMsg("%2.2f %2.2f %2.2f \n", posX, posY, posZ);
}
*/


const std::string FILENAME = "gui_description.xml";

ConfigTool::ConfigTool(float scrw, float scrh)
{
	screenWidth = scrw;
	screenHeight = scrh;
	initialized = false; 
	holder = 0;
	visible = false;
}

ConfigTool::~ConfigTool()
{
	holder = 0;
}


bool ConfigTool::update(MSG msg)
{
	if(!visible) return false;

	const int w = 1024;
	const int h = 768;
	
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();	
	glOrtho(0, w, h, 0,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix(); 
	glLoadIdentity();

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glColor3f(1,1,1);
	
	holder->render(0);
	
	holder->font->setColor(1,1,1);
	holder->font->printCenteredX("Enter save | F9 reload xml | F1 reinits all effects", 1024>>1, 760);

	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	if(dmsGetKey(VK_RETURN))
	{
		dmsSetKey(VK_RETURN, false);
	//	tool->save();
		MessageBox(dmsGetHWND(),"Data saved successfully","Data saved",0);
	}


	if(dmsGetKey(VK_F9))
	{
		dmsSetKey(VK_F9, false);
	//	tool->load();
		MessageBox(dmsGetHWND(),"Data loaded successfully","Data loaded",0);
	}


	float mx = dmsGetMouseX() / screenWidth * w;
	float my = dmsGetMouseY() / screenHeight * h;
	holder->processEvent(GUIMouseMovedEvent(mx, my));

	if(dmsGetMouseLeft())
	{
		holder->processEvent(GUIMousePressedEvent(mx, my));
		GUIElement *e = holder->getFocused();
		int type = (e ? e->getWidgetType() : -1);
		//if( type != GUISLIDER )
		{
			dmsSetMouseLeft();
		}
	}

	if(dmsGetMouseRight())
	{
		holder->processEvent(GUIMousePressedEvent(mx, my, false, false, true));
	}


	if(dmsGetKey(VK_TAB))
	{
		holder->processEvent(GUIKeyboardEvent("tab", false, dmsGetKey(VK_SHIFT)));
		dmsSetKey(VK_TAB, false);
	}

	if(dmsGetKey(VK_LEFT))
	{
		holder->processEvent(GUIKeyboardEvent("left", true, dmsGetKey(VK_SHIFT)));
	}

	if(dmsGetKey(VK_RIGHT))
	{
		holder->processEvent(GUIKeyboardEvent("right", true, dmsGetKey(VK_SHIFT)));
	}

	if(dmsGetKey(VK_F1))
	{
		dmsResetEffects();
	}

	return true;
}

void ConfigTool::init()
{
	this->initialized = true;

	holder  = new GUIHolder();
	holder->init();
}


void ConfigTool::deinit()
{
	if(initialized==false)
		return;

	this->holder->deinit();
}


// ------------------------------------
// ID Stuff
// ------------------------------------
/*
std::string getNamebyID(int n) 
{
	int i;
	for(i=0; i<UI_CHOICES; i++)
		if(mainchoices[i].ID == n)
			return mainchoices[i].name;

	return "";
}


int getIDbyName(std::string name) 
{
	int i;
	for(i=0; i<UI_CHOICES; i++)
		if(mainchoices[i].name == name)
			return mainchoices[i].ID;
	
	return -1;
}
*/

void ConfigTool::load_and_dump()
{

    TiXmlDocument doc( "gui_description.xml" );
    bool loadOkay = doc.LoadFile();

    if ( loadOkay )
    {
        dumpXml( &doc );
    }
    else
    {
        dmsMsg( "ERROR: ConfigTool: Error occured: %s \n", doc.ErrorDesc() );
    }
}

void ConfigTool::dumpXml(TiXmlNode * pParent, unsigned int indent)
{
    if ( !pParent ) return;

    TiXmlText *pText;
    int t = pParent->Type();
    dmsMsg( "%s", getIndent( indent));

    switch ( t )
    {
    case TiXmlNode::DOCUMENT:
        dmsMsg( "Document" );
        break;

    case TiXmlNode::ELEMENT:
        dmsMsg( "Element \"%s\"\n", pParent->Value() );
        break;

    case TiXmlNode::COMMENT:
        dmsMsg( "Comment: \"%s\"\n", pParent->Value());
        break;

    case TiXmlNode::UNKNOWN:
        dmsMsg( "Unknown\n" );
        break;

    case TiXmlNode::TEXT:
        pText = pParent->ToText();
        dmsMsg( "Text: [%s]\n", pText->Value() );
        break;

    case TiXmlNode::DECLARATION:
        dmsMsg( "Declaration\n" );
        break;
    default:
        break;
    }
    printf( "\n" );

    TiXmlNode * pChild;

    for ( pChild = pParent->FirstChild(); pChild != 0; pChild = pChild->NextSibling()) 
    {
        dumpXml( pChild, indent+2 );
    }
}

const char * ConfigTool::getIndent( unsigned int numIndents )
{
    static const char * pINDENT = "                                      + ";
    static const unsigned int LENGTH = strlen( pINDENT );

    if ( numIndents > LENGTH ) numIndents = LENGTH;

    return &pINDENT[ LENGTH-numIndents ];
}

void ConfigTool::load()
{

    dmsMsg( "Loading config tool data\n" );

    TiXmlDocument doc( FILENAME );
    bool loadOkay = doc.LoadFile();

    if ( loadOkay )
    {

		holder->clearWidgest();

		TiXmlHandle hDoc(&doc);
		TiXmlElement* pElem;
		TiXmlHandle hRoot(0);

		pElem=hDoc.FirstChildElement().Element();
		if (!pElem) 
		{
			
			dmsMsg("No \"root\" element found \n");
			return;
		}
		hRoot=TiXmlHandle(pElem);

		pElem=hRoot.FirstChild( "widgets" ).FirstChild().Element();
		if (!pElem) 
		{
			dmsMsg("ERROR: ConfigTool: No \"widgets\" element found \n");
			return;	// TODO: Error reporting
		}
	
		for( pElem; pElem; pElem=pElem->NextSiblingElement())
		{
			loadElement( pElem );
		}

    }
    else
    {
        dmsMsg( "ERROR: ConfigTool: Error occured: %s \n", doc.ErrorDesc() );
    }
}

Vector3 ConfigTool::getPosition(int index)
{
	return Vector3(getX(), getY(), 0);
}

float ConfigTool::getX()
{
	const int w = 300;
	const int h = 35;
	const int margin = 25;
	const int blockw = w + margin;
	const int blockh = h + margin;

	const int ELEMCOUNT = 12;
	int elems = holder->getElementCount()+1;
	float xpos = 10;
	float ypos = blockh*(holder->getElementCount()+1);
	//while(ypos+h > 600) { ypos -= 600; xpos+=blockw; }
	//xpos += int((ypos)/600) * blockw;
	while(elems > ELEMCOUNT) { elems -= ELEMCOUNT; xpos+=blockw; }

	return xpos;
}

float ConfigTool::getY()
{

	const int w = 250;
	const int h = 35;
	const int margin = 10;
	const int blockh = h + margin;
	float ypos = blockh*(holder->getElementCount()+1);
	
	const int ELEMCOUNT = 12;
	int elems = holder->getElementCount()+1;
	while(elems > ELEMCOUNT) { elems -= ELEMCOUNT; ypos-=blockh*ELEMCOUNT; }
	return ypos;
}

void ConfigTool::loadElement(TiXmlElement * pParent)
{
    if ( !pParent ) return;

	const int w = 200;
	const int h = 35;

    //TiXmlText *pText;
    int t = pParent->Type();

    switch ( t )
    {
    case TiXmlNode::ELEMENT:

		 if(strcmp(pParent->Value(), "ColorSelector")==0)
		 {
			std::string callback = pParent->Attribute("Callback");
			std::string cb;
			GUISlider *e;
			cb = callback+"r";
			e = new GUISlider(getX(), getY(), w, h, cb.c_str(), 0.4f, "true");
			e->loadElement(pParent);
			holder->addWidget(e);
			e->setLeft(0.39f, 0, 0);
			e->setRight(0.89f, 0, 0);

			cb = callback+"g";
			e = new GUISlider(getX(), getY(), w, h, cb.c_str(), 0.4f, "true");
			e->loadElement(pParent);
			holder->addWidget(e);
			e->setLeft(0, 0.39f, 0);
			e->setRight(0, 0.89f, 0);

			cb = callback+"b";
			e = new GUISlider(getX(), getY(), w, h, cb.c_str(), 0.4f, "true");
			e->loadElement(pParent);
			holder->addWidget(e);
			e->setLeft(0,0,0.39f);
			e->setRight(0,0,0.89f);
		 }
		 else if(strcmp(pParent->Value(), "ToggleButton")==0)
		 {
			GUIToggleButton *e = new GUIToggleButton(getX(), getY(), w, h, pParent->Attribute("Callback"), "label", true);
			e->loadElement(pParent);
			holder->addWidget(e);
		 }
		 else if(strcmp(pParent->Value(), "Button")==0)
		 {
			GUIButton *e = new GUIButton(getX(), getY(), w, h, pParent->Attribute("Callback"), "label");
			e->loadElement(pParent);
			holder->addWidget(e);

		 }
		 else if(strcmp(pParent->Value(), "Slider")==0)
		 {
			GUISlider *e = new GUISlider(getX(), getY(), w, h, pParent->Attribute("Callback"), 0.4f, "true");
			e->loadElement(pParent);
			holder->addWidget(e);
		 }
		 else if(strcmp(pParent->Value(), "TextField")==0)
		 {
			GUITextField *e = new GUITextField(getX(), getY(), w, h, pParent->Attribute("Callback"), 256, "sadf");
			e->loadElement(pParent);
			holder->addWidget(e);
		 }
		 else if(strcmp(pParent->Value(), "Label")==0)
		 {
			GUILabel *e = new GUILabel(getX(), getY(), w, h, pParent->Attribute("Callback"), "label");
			e->loadElement(pParent);
			holder->addWidget(e);
		 }

        break;

	default:
        dmsMsg( "Unknown xml element\n" );
        break;
    }
    printf( "\n" );
}


void ConfigTool::save()
{

	TiXmlDocument doc;  
	TiXmlComment * comment;
	std::string s;
 	TiXmlDeclaration* decl = new TiXmlDeclaration( "1.0", "", "" );  
	doc.LinkEndChild( decl ); 
 
	TiXmlElement * root = new TiXmlElement("root");  
	doc.LinkEndChild( root );  

	comment = new TiXmlComment();
	s="GUIWidgetit fileen ja noin";
	comment->SetValue(s.c_str());  
	root->LinkEndChild( comment );  

	TiXmlElement *widgets = new TiXmlElement("widgets");
	root->LinkEndChild(widgets);

	holder->writeXml(widgets);

	doc.SaveFile( FILENAME );  
}

float ConfigTool::getValue(const char *text)
{
	GUIElement *e = holder->getByCallback(text);
	if(e!=0)
	{
		if(e->getWidgetType() == GUISLIDER)
		{
			return ((GUISlider*)e)->getValue();
		}
	}

	MessageBox(0,"No such element in Tool.\nOr element was not slider!", text,0);
	dmsShutDown();
	exit(0);
}

Vector3 ConfigTool::getColor(const char *text)
{
	std::string c = text;

	Vector3 color = Vector3();
	color.x = getValue((c+"r").c_str());
	color.y = getValue((c+"g").c_str());
	color.z = getValue((c+"b").c_str());

	return color;
}

Vector3 ConfigTool::setColor(const char *text)
{
	std::string c = text;

	Vector3 color = Vector3();
	color.x = getValue((c+"r").c_str());
	color.y = getValue((c+"g").c_str());
	color.z = getValue((c+"b").c_str());

	glColor3f(color.x, color.y, color.z);
	return color;
}