//--------------------------------------------------------------------------------------------
//  Headers
//--------------------------------------------------------------------------------------------

#include <windows.h>

#ifdef _DEBUG
	#include <stdio.h>
	//#include "mmgr.h"
#endif

#include "textManager.hpp"
#include "globals.hpp"

//--------------------------------------------------------------------------------------------
//  Use our library namespace: TRACTION_DEMOTRACTOR
//--------------------------------------------------------------------------------------------

using namespace TRACTION_DEMOTRACTOR;

//--------------------------------------------------------------------------------------------
//  Static members
//--------------------------------------------------------------------------------------------

bool TextManager::createdFlag = false;
TextManager *TextManager::instance = NULL;

//--------------------------------------------------------------------------------------------
//  Externals
//--------------------------------------------------------------------------------------------

extern TextManager *tManager;

//--------------------------------------------------------------------------------------------
//  Class code
//--------------------------------------------------------------------------------------------

TextManager::TextManager()
{
	nTexts = 0;	
}

TextManager::~TextManager()
{
}

TextManager *TextManager::create()
{

	if(!createdFlag)
	{					
		instance = new TextManager;
		if(!instance)
		{
			throw "TextManager::create(): Memory allocation error";
		}
		
		createdFlag = true;

		dmsMsg("TextManager::create(): TextManager instance created\n");
	}
	else
	{		
		throw "TextManager::create(): One instance of class TextManager allready funning\n";
	}	

	return instance;
}

void TextManager::debug()
{
	texts.debug();
}

void TextManager::release()
{	
	if(createdFlag)
	{
		//
	
		createdFlag = false;
		nTexts = 0;

		if(instance)
		{
			instance->texts.freeList();
			delete instance;
			instance = NULL;
		}

		dmsMsg("FontManager::release(): Instance deleted\n");		
	}
}
bool TextManager::addText(char *filename, const char *str, int strLen)
{
	std::string *n = new std::string(str, strLen);
	texts.addTail(n, filename, 0);
	nTexts++;

	dmsMsg("TextManager::addText(): File \"%s\" loaded and added \"%s\".\n", filename, filename);

	return true;
}

bool TextManager::addText(char *filename, std::string text)
{
	std::string *n = new std::string(text);
	texts.addTail(n, filename, 0);
	nTexts++;

	dmsMsg("TextManager::addText(): File \"%s\" loaded and added \"%s\".\n", filename, filename);

	return true;
}

bool TextManager::addTextFromFile(char *fname, char *name)
{
	char tmpLine[256] = {0};
	int count = 0;

	std::fstream f;
	f.open(fname, std::ios::in|std::ios::binary);

	if (!f.is_open() || !f.good())
	{
		MessageBox(dmsGetHWND(), "TextManager::addTextFromFile(): Failed to load file ", fname, MB_OK|MB_TOPMOST);
		dmsMsg("ERROR: TextManager::addTextFromFile(): Failed to load file filename: \"s\"\n", fname);
		return false;
	}

	while(!f.eof())
    {
		f.getline(tmpLine, 256, '\n');
        count++;
	}

	f.close();

	if(count == 0) return 0;
	if (!f.is_open() || !f.good())
	{

	}

   ifstream input;

   char *src = new char[256 * count];

   input.open(fname);
	
   if(!input.is_open() || !input.good())
   {
		MessageBox(dmsGetHWND(), fname, "Failed to load file ; input", MB_OK|MB_TOPMOST);
		dmsMsg("ERROR: Failed to load ; input %s\n", fname);
		return false;
   }

   input.getline(src , 256 * count, '\0');

   input.close(); // Close the shader.

   std::string *n = new std::string(src);
	texts.addTail(n, name, 0);	
   //texts.addTail(&src, name, 0);
	nTexts++;


   	dmsMsg("TextManager::addText(): File \"%s\" loaded and added as text \"%s\".\n", fname, name);

	return true;
}

//-------------------------------------------------------
// Getters
//-------------------------------------------------------

unsigned int TextManager::getTextCount()
{
	return nTexts;
}

std::string *TextManager::getText(unsigned int index)
{
	Node<std::string> *getNode = NULL;

	(index > nTexts-1) ? index = nTexts-1 : index = index;
	(index < 0) ? index = 0 : index = index;
	
	getNode = texts.get(index);

	if(getNode!=NULL) return getNode->a;


	return NULL;
}

std::string *TextManager::getTextName(char *name)
{
	Node<std::string> *getNode = NULL;
	
	getNode = texts.find(name);
	
	if(getNode!=NULL) return getNode->a;

	return NULL;
}
