#ifndef _GUISLIDER_H_
#define _GUISLIDER_H_

#define USE_UNSIGNED_CHAR true

#include "GUIInclude.h"
#include "GUIEvent.h"
#include "GUIButton.h"
#include "GUIHolder.h"

class GUIHolder;
class GUIElement;
class GUISlider : public GUIElement
{
public:
	
	GUISlider(float x, float y, float w, float h, const char *callback, float initialvalue, std::string label, float minim=0, float maxim=255);
	
	virtual void render(float dt);
	virtual std::string checkMousePressedEvents(GUIMousePressedEvent &me);
	virtual std::string checkKeyboardEvents(GUIKeyboardEvent &me);	
	virtual std::string checkMouseMovedEvents(GUIMouseMovedEvent &me);// {GUIElement::checkMouseMovedEvents(me); return "";};

	virtual void setLeft(float r,float g, float b);
	virtual void setRight(float r,float g, float b);

	void setSmallAdjustment(float i);
	void setBigAdjustment(float i);

	void setMinimum(float i);
	void setMaximum(float i);
	
	virtual float getValue();
	virtual void setValue(float val);
	
	virtual void writeToXml(TiXmlElement *parent);
	virtual void loadElement(TiXmlElement * element);

protected:

	std::string label;
	float scale;
	float left[3];
	float right[3];
	float smallAdjustment;
	float bigAdjustment;
	float minimum;
	float maximum;
};


#endif