#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Alkuotukset.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

// Yes nice hack - sry :)
bool alkuotuksetResetCamera;

void Alkuotukset::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.975f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}


/////////////////////////////////////////////////////////////////////////////
///                          Alkuotus
/////////////////////////////////////////////////////////////////////////////


void Alkuotus::init()
{
	alkuotuksetResetCamera = true;
    const float xdim = 15.0f;
    const float ydim = 8.0f;
    const float zdim = 15.0f;

    Vector3 initialPos = Vector3(Math::randBetween(-xdim, xdim), 
                                 Math::randBetween(0, ydim),
                                 Math::randBetween(-zdim, zdim));

    this->movement.setUseBounds(true);
    this->movement.setPosition(initialPos);
    this->movement.setDirection(Math::randBetween(0, 2*3.141592f), Math::randBetween(0, 2*3.141592f));
    this->movement.setBoundLimits(-xdim, xdim, 0, ydim, -zdim, zdim);
    this->movement.setTurning(0, 0);
    this->movement.setSpeed(Math::randBetween(0.0045f, 0.007f));

    const float harmaa = Math::randBetween(0.3f, 0.5f);
    this->color = Vector3(harmaa, harmaa, harmaa);//0.3f, 0.3f, Math::randBetween(0.4f, 0.7f));
    this->phase = Math::randFloat();
    this->phasespeed = Math::randBetween(0.01f, 0.02f);
}

void Alkuotus::turn()
{
}

void Alkuotus::draw(float alpha)
{
    glColor4f(this->color.x, this->color.y, this->color.z, alpha * (0.6f + 0.4f * sinf(this->phase)));
    Vector3 &p = this->movement.getPosition();
    glVertex3fv((float *)&p);
}
void Alkuotus::drawLine(float alpha, float modulate)
{
	if(fabs(1.0f-modulate)>0.00001f) 
	{
		this->color*=modulate;
		this->color.clamp(Vector3(1,1,1), Vector3(0,0,0));
	}

    glColor4f(this->color.x, this->color.y, this->color.z, alpha * (0.6f + 0.4f * sinf(this->phase)));
    glVertex3fv((float *)&this->movement.getPosition());
    glVertex3fv((float *)&this->movement.getPreviousPosition());
}


void Alkuotus::update()
{
    this->movement.update();
    if (Math::randFloat() < 0.01f)
    {
        this->movement.selectNewDirection();
    }

    this->phase += this->phasespeed;
}

void Alkuotukset::renderScene(float pos, float alpha)
{
/*
    static float lastpos = 0.0f;
    float dt = pos - lastpos;
    dmsMsg("dt = %f\n", dt);
    lastpos = pos;
*/

 
    std::vector<Alkuotus>::iterator it;

    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (it = otukset.begin(); it < otukset.end(); it++)
        {
            (*it).update();
        }
        this->frametimer->endStep();
    }
	if(alkuotuksetResetCamera)
	{
		glLoadIdentity();
		cameras->useCamera(this->cameraindex);
	}
    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDisable(GL_TEXTURE_2D);
    glBegin(GL_POINTS);
    for (it = otukset.begin(); it < otukset.end(); it++)
    {
        (*it).draw(alpha);
    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);

}




Alkuotukset::Alkuotukset(int cam)
{	
    this->cameraindex = cam;
    this->frametimer = new FrameTimer(1000 / 60, 5);
    for (int i = 0; i < 1000; i++)
    {
        Alkuotus otus;
        otus.init();
        this->otukset.push_back(otus);
    }
}

Alkuotukset::~Alkuotukset()
{
}


bool Alkuotukset::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

