#ifndef _Meduusa_HPP_
#define _Meduusa_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../groundplane.hpp"
#include <vector>
#include <list>
#include "alkuotukset.h"

Vector3 tentacleTurbulence1(Vector3 &pos, float time);
Vector3 tentacleTurbulence2(Vector3 &pos, float time);
Vector3 tentacleTurbulence3(Vector3 &pos, float time);
Vector3 tentacleTurbulence4(Vector3 &pos, float time);


/////////////////////////////////////////////////// MEDUUSAT ///////////////////////////////////////////////////////////
class Tentacle
{
public:
    Tentacle();
    ~Tentacle();

    void init(Vector3 &startpos);
    void free();
    void draw(float time, Vector3 &color, float alpha);
    void update(float time);

private:
    CatmullRom *spline;
    float phase;
    int function;


};
class Jellyfish
{
public:
    Jellyfish();
    ~Jellyfish();

    void init(bool first, Vector3 &startpos);
    void draw(float alpha, float pos, float colorsync);
    void drawGlowyBits(float alpha, float colorsync);

    void update(int currentTime);
    Vector3 position;

private:
    bool special;
    std::vector<Tentacle> tentacles;

    int pointcount;
    int stripcount;
    
    Vector3 *alareuna;
    Vector3 **points;
    Vector3 **texcoords;

    Vector3 color;
    Vector3 color2;
    Vector3 color3;
    Vector3 color4;

    Vector3 orientation;
    Vector3 velocity;
    float a, b;

    float phase;
    float size;
    float speed;
    float time;

    float st, et;
    float appear;
};

/////////////////////////////////////////////////// TILPE ///////////////////////////////////////////////////////////

class PlankShell
{
public:
	Vector3 pos;
	Vector3 endpos;
};

/////////////////////////////////////////////////// PARTICLET ///////////////////////////////////////////////////////////

class MedusaParticle
{
public:
    MedusaParticle();
    ~MedusaParticle();
    void update();
    void draw(float alpha);
    bool isDead();
    
    int func;
    Vector3 pos;
    float energy;
    float maxenergy;
    float size;
    float time;
    float timespeed;
};


class MedusaEmitter
{
public:
    MedusaEmitter();
    ~MedusaEmitter();

    void init();
    void initPos();
    void update();
    void draw(float alpha);

    Texture *texture;
    Vector3 pos;
    std::list<MedusaParticle> particles;
};

/////////////////////////////////////////////////// EFEKTI ///////////////////////////////////////////////////////////

class Meduusa : public Base
{
	public:

		Meduusa();
		~Meduusa();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private: 

		TriggerSystem *medusatrigut;

		TriggerSystem *trigut;
		TriggerSystem *trigut2;

		int obuCount;
		PlankShell *obut;

        FrameTimer *frametimer;
        GroundPlane *merenpohja;
        std::vector<class Jellyfish> meduusat;
        std::vector<class MedusaEmitter> emitterit;
		void renderScene(float pos, float alpha);

		CatmullRom *campos;
		CatmullRom *camtgt;
        Analyzer *anal;
};

#endif

 