#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "MetaKappyra.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

extern void setClearColor(Vector3 color);
void MetaKappyra::draw()
{
	setClearColor(Vector3(0,0,0));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);

}

void MetaKappyra::renderScene(float pos, float alpha)
{
	Vector3 d;
 
	int i;


    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
		for(i=0; i<obuCount; i++)
		{
			d = obut[i].origpos - obut[i].pos;
			float dsqr = d.x*d.x + d.y*d.y + d.z*d.z;
			if(dsqr > 1.0f)
			{
				d = d.normalize();
				obut[i].pos += d * 0.10f * dsqr * dsqr;
			}
		
			Vector3 tmp = obut[i].pos;
			obut[i].pos += ((obut[i].pos - obut[i].oldpos));//*0.99999f);
			obut[i].oldpos = tmp;
		}

        this->frametimer->endStep();
    }

    Vector3 cam = Vector3(0, 0, -65);
    Vector3 tgt = Vector3(0, 0, 0);
    
	float angle = 0.15f * sinf(this->time*0.00015f);
    Matrix uprot;
    uprot.makeRotation(0, 0, angle);
    Vector3 upw = Vector(0, 1, 0) * uprot;
	upw = upw.normalize();

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

	float h = 83.0f;
	glTranslatef(0, -h + 2*h * pos, 0);


// -----------------

filter.init();

	//glDepthMask(0);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

	float modi = 1.0f/32.0f;
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_white.jpg")->getID());
    glBegin(GL_QUADS);
	Vector3 p;
	
	glColor3f(alpha, alpha, alpha);
	float size;
	for(i=0; i<obuCount; i++)
	{
		size = 1.0f + 1.0f * (i&31) * modi;
		p = obut[i].pos;

		Vector3 sizexr = xr * size;
		Vector3 sizeyr = yr * size;
		Vector3 v1 = p - sizexr - sizeyr;//xr * -size + yr * -size;
		Vector3 v2 = p + sizexr - sizeyr;//+ xr *  size + yr * -size;
		Vector3 v3 = p + sizexr + sizeyr;//xr *  size + yr *  size;
		Vector3 v4 = p - sizexr + sizeyr;//xr * -size + yr *  size;

		
		glTexCoord2f(0, 0);
		glVertex3fv((float *)&v1);
		glTexCoord2f(1, 0);
		glVertex3fv((float *)&v2);
		glTexCoord2f(1, 1);
		glVertex3fv((float *)&v3);
		glTexCoord2f(0, 1);
		glVertex3fv((float *)&v4);
    
	}
    glEnd();

	
	glEnable(GL_DEPTH_TEST);

filter.applymetafake();

}




MetaKappyra::MetaKappyra()
{	
    this->frametimer = new FrameTimer(1000 / 40, 5);
}

MetaKappyra::~MetaKappyra()
{
}


bool MetaKappyra::init(unsigned long s, unsigned long e)
{
	const int stacks = 4;
	const int items = 35;

	obuCount = stacks*items;
	obut = new MetaOlio[obuCount];

	srand(2);

	Vector3 p, o;
	for(int n=0; n<stacks; n++)
	{
		o.x = Math::randBetween(-35.0f, 35.0f);
		o.y = Math::randBetween(-30.0f, 30.0f);
		o.z = Math::randBetween(-5.0f, 45.0f);
		//o = Math::randVectSphere() * 26.0f;
		//o.x = 0;
		
		for(int i=0; i<items; i++)
		{
			int z = n*items + i;
			p = o + Math::randVectSphere() * 1.8f;
			
			obut[z].pos = p;
			obut[z].oldpos = p + Math::randVector() * 1.0f;
			obut[z].origpos = p;
		}
	}



	startTime = s;
	endTime = e;
	return true;
}

