#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Nilviaiset.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Nilviaiset::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}


//////////////////////////////////////////////////////////////////////////////////////////////////
//                                       SpiraaliOtus                                           //
//////////////////////////////////////////////////////////////////////////////////////////////////

void SpiraaliOtus::init()
{
    int i = 0;

    float a = Math::randBetween(0, 2*3.141592f);
    float r = 10 * powf(Math::randFloat(), 0.5f);//* Math::randFloat();
    float y = Math::randBetween(0.1f, 0.2f);

    this->position = Vector(cosf(a) * r, y, sinf(a) * r);
    this->rotation = Vector3(0, 0, 0);//Math::randVectSphere();
    this->color = Math::randVectSphere().normalize();
    this->spline = new CatmullRom();
    this->spline2 = new CatmullRom();

    const int points = 150;
    const float startradius = 0.0;
    const float endradius = Math::randBetween(0.2f, 0.5f);
    const float kierroksia = Math::randBetween(4, 6);
    const float korkeus = Math::randBetween(0.1f, 0.6f);

    this->spline->startCreation();
    this->spline2->startCreation();

    for (i = 0; i < points; i++)
    {
        float t = i / (float)points;
        float a = t * 2 * 3.141592f * kierroksia;
        float r = startradius + (endradius - startradius) * t;
        float y = t * korkeus;

        const float dt = 1.0f / kierroksia;
        float a2 = (t + dt) * 2 * 3.141592f * kierroksia;
        float r2 = startradius + (endradius - startradius) * (t + dt);
        float y2 = (t + dt) * korkeus;

        Vector3 p = Vector3(cosf(a)* r, y, sinf(a) * r);
        Vector3 p2 = Vector3(cosf(a2)* r2, y2, sinf(a2) * r2);
        this->spline->addPoint(p);
        this->spline2->addPoint(p2);
    }
    this->spline->endCreation();
    this->spline2->endCreation();
    this->spline->arcLengthParametrize();
    this->spline2->arcLengthParametrize();

}
void SpiraaliOtus::free()
{
}
void SpiraaliOtus::draw(float alpha)
{
    int i = 0;
    glPushMatrix();
    glTranslatef(this->position.x, this->position.y, this->position.z);
    glRotatef(360 * this->rotation.x, 1, 0, 0);
    glRotatef(360 * this->rotation.y, 0, 1, 0);
    glRotatef(360 * this->rotation.z, 0, 0, 1);

    const int strips = 300;
/*
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glBegin(GL_QUAD_STRIP);
    glColor4f(this->color.x, this->color.y, this->color.z, alpha*0.3f);
    for (i = 0; i < strips; i++)
    {
        float t = i / (float)strips;
        Vector3 p = this->spline->getValue(t);
        Vector3 p2 = this->spline2->getValue(t);
        glVertex3fv((float *)&p);
        glVertex3fv((float *)&p2);
    }
    glEnd();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDisable(GL_DEPTH_TEST);
    glBegin(GL_LINE_STRIP);
    glColor4f(this->color.x, this->color.y, this->color.z, alpha * 0.5f);
    for (i = 0; i < strips; i++)
    {
        float t = i / (float)strips;
        Vector3 p = this->spline2->getValue(t);
        glVertex3fv((float *)&p);
    }
    glEnd();
    glEnable(GL_DEPTH_TEST);
*/
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glBegin(GL_LINE_STRIP);
    for (i = 0; i < strips; i++)
    {
        float t = i / (float)strips;
        glColor4f(this->color.x, this->color.y, this->color.z, alpha * 0.7f * sinf(t * 3.14152f));
        Vector3 p = this->spline->getValue(t);
        glVertex3fv((float *)&p);
    }
    glEnd();
    glPopMatrix();
}
void SpiraaliOtus::update()
{
}

bool SpiraaliOtus::isDead()
{
    return false;
}


//////////////////////////////////////////////////////////////////////////////////////////////////
//                                       Pohjakasvi                                             //
//////////////////////////////////////////////////////////////////////////////////////////////////


void Kasvinauha::init(Vector3 &color, Vector3 &startpos)
{
    int i = 0;

    this->color = color;
    this->spline = new CatmullRom();
    this->spline->startCreation();

    const int points = 10;
    Vector3 p = startpos;

    for (i = 0; i < points; i++)
    {
        spline->addPoint(p);

        const float step = 0.2f;
        Vector3 d = Math::randVectSphere()*step;
        d.y += step;

        p += d;
    }
    spline->endCreation();
    spline->arcLengthParametrize();
}

static int nauhoja = 0;

void Pohjakasvi::init()
{
    int i = 0;

//    this->time = Math::randBetween(-4.0f, 1.0f);
    this->time = 0.0f;
    float a = Math::randBetween(0, 2*3.141592f);
    float r = 1 * powf(Math::randFloat(), 0.5f);//* Math::randFloat();
    float y = Math::randBetween(0.1f, 0.2f);

    Vector3 loc = Vector3(sinf(a) * r, 0, cosf(a) * r);

    Vector3 color = Math::randVectSphere().normalize();
    for (i = 0; i < 1; i++)
    {
        Kasvinauha n;
        float a2 = Math::randBetween(0, 2*3.141592f);
        float r2 = 0.3f * powf(Math::randFloat(), 0.5f);//* Math::randFloat();
        Vector3 startpos = loc + Vector3(sinf(a2) * r2, 0, cosf(a2) * r2);
        n.init(color, startpos);
        this->nauhat.push_back(n);
//        nauhoja++;
//        dmsMsg("nauhoja = %d\n", nauhoja);
    }

}

void Pohjakasvi::free()
{
}

void Pohjakasvi::draw(float alpha)
{
    if (this->time < 0.0f)
        return;

    std::vector<Kasvinauha>::iterator it;
    for (it = this->nauhat.begin(); it < this->nauhat.end(); it++)
    {
        Kasvinauha &n = *it;
        glColor4f(n.color.x, n.color.y, n.color.z, alpha);

        const float step = 1.0f / 60;
        glBegin(GL_LINE_STRIP);
        for (float t = 0.0f; t < this->time; t += step)
        {
            glVertex3fv((float *)&n.spline->getValue(t));
        }
        glEnd();
        nauhoja++;
    }
}

void Pohjakasvi::update()
{
    this->time += 0.001f;
    if (this->time > 1.00f)
        this->time = 1.0f;
//    dmsMsg("kasvin aika = %f\n", this->time);
}

bool Pohjakasvi::isDead()
{
    return false;
}


//////////////////////////////////////////////////////////////////////////////////////////////////
//                                       efekti itse                                            //
//////////////////////////////////////////////////////////////////////////////////////////////////

void Nilviaiset::renderScene(float pos, float alpha)
{
 
    std::list<SpiraaliOtus>::iterator it;
    std::list<Pohjakasvi>::iterator it2;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (it = this->otukset.begin(); it != this->otukset.end(); )
        {
            Nilviainen &otus = *it;
            otus.update();
            
            if (otus.isDead())
            {
                otus.free();
                it = this->otukset.erase(it);
            }
            else
            {
                it++;
            }

        }

        for (it2 = this->kasvit.begin(); it2 != this->kasvit.end(); it2++)
        {
            Pohjakasvi kasvi = *it2;
            kasvi.update();
        }
        this->frametimer->endStep();
    }
 
    glLoadIdentity();
    cameras->useCamera(1);

    this->merenpohja->render(dmsGetTexture("deeptxt2.jpg"), alpha*0.2f);

    glLineWidth(2.0f);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_LINE_SMOOTH);
    filter.init();

/*
    for (it = this->otukset.begin(); it != this->otukset.end(); it++)
    {
        SpiraaliOtus &otus = *it;
        otus.draw(alpha);
    }
*/
//    dmsMsg("kasvien koko = %d\n", (int)this->kasvit.size());
    for (it2 = this->kasvit.begin(); it2 != this->kasvit.end(); it2++)
    {
        Pohjakasvi &kasvi = *it2;
        kasvi.draw(alpha);
    }
//    dmsMsg("piirrettiin %d nauhaa\n", nauhoja);
    glDisable(GL_LINE_SMOOTH);
    filter.glow(6, 0.007f, 0.007f, 0.91f, -1.0f, 1.0f);
    glDisable(GL_BLEND);
}




Nilviaiset::Nilviaiset()
{
    int i = 0;
    const int groundX = 50;
    const int groundY = 50;
    const float size2 = 15.0f;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 4.0f);
    this->merenpohja->makeCircularFade(1.0f, 1.0f);

    this->frametimer = new FrameTimer(1000 / 60, 5);

    srand(6101961); 
    for (i = 0; i < 60; i++)
    {
        SpiraaliOtus otus;
        otus.init();
        this->otukset.push_back(otus);
    }

    for (i = 0; i < 100; i++)
    {
        Pohjakasvi kasvi;
        kasvi.init();
        this->kasvit.push_back(kasvi);
    }

}

Nilviaiset::~Nilviaiset()
{
}


bool Nilviaiset::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

