#ifndef _Pohja_HPP_
#define _Pohja_HPP_

#include <stdio.h>
#include <vector>
#include <list>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../groundplane.hpp"
#include "../analyzer.hpp"
#include "alkuotukset.h"
#include "../boundedmovement.h"


class Kolmikko
{
public:
    void init(Vector3 &position, float start, float sizemod = 1.0f);
    void update();
    void render(float alpha, Vector3 &xr, Vector3 &yr);
    void setFade();
    
    float fadeTimer;

    Vector3 p1, p2, p3;
    float f1, f2, f3;
    float f1max, f2max, f3max;
    float s1, s2, s3;

    float h1, h2, h3;
    float t1, t2, t3;
    bool canEmit;
    float emitTimer;
};

class Nouseva
{
public:
    void update();
    void render(float alpha, float sync, Vector3 &xr, Vector3 &yr, int id);
    bool isDead();

    Vector3 position;
    Vector3 rotation;
    Vector3 rotationdelta;
    float size;
    float time;
};

class Pohja : public Base
{
	public:

		Pohja();
		~Pohja();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private: 
        std::vector<Alkuotus> otukset;
        GroundPlane *merenpohja;
        std::vector<Kolmikko> kolmikot;
        std::vector<Kolmikko> kolmikot2;
        std::list<Nouseva> nousevat;
        Analyzer *anal;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
};

#endif

 