#ifndef _Ropes_HPP_
#define _Ropes_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"
#include "../analyzer.hpp"
#include "alkuotukset.h"
#include "oliot.h"

class VerletObject
{
	friend class VerletConstraint;
	friend class VerletStick;
public:

	VerletObject();
	~VerletObject();

	void setPosition(Vector3 p);
	void setSpeed(Vector3 v);
	void setMass(float m);

	Vector3 getPosition();
	Vector3 getSpeed();
	float getMass();
	
	void resetForces();
	void accumulateForces();
	
	void update();	

	void destroy();

	bool getStatic();
	void setStatic(bool b);

VerletObject *mother;

	bool mStatic;
	Vector3 mPos;
	Vector3 mOldPos;
	Vector3 mForce;
	float mMass;
	float mInvMass;
	bool mAlive;
};

class VerletConstraint
{
	friend class VerletEngine;
	
public:

	VerletConstraint();
	~VerletConstraint();

	void setObjects(VerletObject *a1, VerletObject *a2);
	void setRestDistance(float l);

	void satisfyConstraint();
	void destroy();

	VerletObject *getObjectA();
	VerletObject *getObjectB();

	VerletObject *mObjectA;
	VerletObject *mObjectB;
	float mRestDistance;
	bool mAlive;
};

typedef std::vector<VerletObject *>	  OList;
typedef std::vector<VerletConstraint *> CList;


class RopeParticle
{
public:
    RopeParticle();
    ~RopeParticle();
    void update();
    void draw(float alpha);
    bool isDead();
    
    int func;
    Vector3 pos;
    float energy;
    float maxenergy;
    float size;
    float time;
    float timespeed;
};


class RopeEmitter
{
public:
    RopeEmitter();
    ~RopeEmitter();

    void init();
    void initPos();
    void update();
    void draw(float alpha);

    Texture *texture;
    Vector3 pos;
    std::list<RopeParticle> particles;
};


class Ropes : public Base
{
	public:

		Ropes();
		~Ropes();

		bool init(unsigned long s, unsigned long e);
		void draw();

		int obutperolio;
		int oliot;
		VerletObject **moveobut;

		void stepLogic();

	private: 
		VerletEngine *vEngine;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
		
		CatmullRom *spl1;
		CatmullRom *spl2;
		CatmullRom *spl3;
		CatmullRom *spl4;
		CatmullRom *spl5;

		OList mObjects;
		CList mConstraints;

        Analyzer *anal;

		TriggerSystem *trigut;
		TriggerSystem *trigut2;

		TriggerSystem *speechtrigu;
        std::vector<class RopeEmitter> emitterit;
};

#endif

 