//#define NOT_FINAL_SIVUTTAIN
#include <math.h>

#include "Sivuttain.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"


extern void setClearColor(Vector3 color);

void Sivuttain::draw()
{
	setClearColor(Vector3(0.005f, 0.005f, 0.01f));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.025f;
	const float fadeoutstart = 0.99f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    renderScene(pos, alpha);
}

/////////////////////////////////////////////////////////////////////////////////////////
//                                     SIVUTTAINOTUS
/////////////////////////////////////////////////////////////////////////////////////////


SivuttainOtus::SivuttainOtus(CatmullRom *masterspline, bool special, int which)
{
    int i;

    this->special = special;
    this->tilpecount = (int)(1500 * (this->special ? 1.5f : 1));
    tilpet = new SivuttainTilpe*[tilpecount];

    if (special)
    {
        if (which == 5 || which == 6)
        {
            this->st = Math::randBetween(0.50, 0.52f);
            this->et = this->st + Math::randBetween(0.02f, 0.03f);
        }
        else
        {
            this->st = Math::randBetween(0.02f, 0.15f);
            this->et = this->st + Math::randBetween(0.02f, 0.06f);
        }
    }
    else
    {
        this->st = 0.0f;
        this->et = 0.001f;
    }

    for (i = 0; i < tilpecount; i++)
    {
        int tilpevert = 10;
        tilpet[i] = new SivuttainTilpe();
        tilpet[i]->curve = new CatmullRom();
		tilpet[i]->curve->startCreation();

        float master_t = Math::randBetween(0.01f, 0.94f);
        float master_t_delta = -0.002f;

        tilpet[i]->delta = Math::randVectSphere()*0.12f;
        tilpet[i]->st = master_t;
        tilpet[i]->et = min(0.97f, tilpet[i]->st + Math::randBetween(0.05f, 0.10f) * (this->special ? 1.5f : 1));

        Vector c1, c2, c3, c4;
        if (special)
        {
            switch(rand()%2)
            {
                case 0:
                {
                    //punainen
                    c1 = Vector(0.9f, 0.4f, 0.15f);
                    c2 = Vector(1.0f, 0.5f, 0.20f);
                    c3 = Vector(0.15f, 0.4f, 0.9f);
                    c4 = Vector(0.20f, 0.5f, 1.00f);
                } break;
                case 1:
                {
                    //keltainen
                    c1 = Vector(0.9f, 0.7f, 0.3f);
                    c2 = Vector(1.0f, 0.8f, 0.3f);
                    c3 = Vector(0.3f, 0.4f, 0.9f);
                    c4 = Vector(0.3f, 0.5f, 1.00f);

                } break;
            }
        }
        else
        {
            switch(rand()%2)
            {
                case 0:
                {
                    //turkoosi
                    c1 = Vector(0.15f, 0.7f, 0.9f);
                    c2 = Vector(0.14f, 0.9f, 1.0f);
                } break;
                case 1:
                {
                    //keltainen
                    c1 = Vector(0.9f, 0.7f, 0.3f);
                    c2 = Vector(1.0f, 0.8f, 0.3f);

                } break;
            }
        }


        float coloralpha = 0.5f;
        float colort = Math::randFloat();
        tilpet[i]->color = (c1 * (1-colort) + c2*colort)*coloralpha;
        tilpet[i]->color2 = (c3 * (1-colort) + c4*colort)*coloralpha;

        if (rand()%80 == 0)
        {
            tilpet[i]->color = Vector(1,1,1);
        }

        const int steps_along_the_spline = 3;
        Vector startpos = masterspline->getValue(master_t);

        for (int j = 0; j < steps_along_the_spline; j++)
        {
            tilpet[i]->curve->addPoint(masterspline->getValue(master_t));
            master_t += master_t_delta;
        }
        Vector3 curpos = masterspline->getValue(master_t);
        Vector3 direction = (curpos - startpos).normalize();

        float rotaatio = Math::randBetween(2.4f, 3.6f)*4;
        Vector rotationdelta = Math::randVectSphere()*10;
        float speed = 0.05f + (0.5f*powf(Math::randFloat(), 1.7f));
        Vector r = Math::randVectSphere()*rotaatio*(1+speed);

        r.x *= master_t;
        r.y *= master_t;

        for (j = steps_along_the_spline; j < tilpevert; j++)
        {
            Matrix rotation;
            rotation.makeRotation(r.x, r.y, r.z);
            tilpet[i]->curve->addPoint(curpos);
            curpos += direction*speed;
            direction *= rotation;
            r += rotationdelta*1.3f; 
        }
		tilpet[i]->curve->endCreation();
    }
}

SivuttainOtus::~SivuttainOtus()
{
}

void SivuttainOtus::draw(float pos, float sync, float alpha)
{
    const float fadein = Math::calcPosFloat(pos, this->st, this->et);
    if (fadein > 0.00001f || !this->special)
    {
        alpha *= fadein;
        int i = 0;
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE);
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DEPTH_TEST);
        glEnable(GL_LINE_SMOOTH);
        glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
        glLineWidth(3.0f);  

    
        int realtime = dmsGetModulePosition();
        const float colorpos = 1-Math::calcPosFloat(realtime*1.0f, 271200.0f, 271700.0f);

        if (this->special)
        {
            for (i = 0; i < tilpecount; i++)
            {
                tilpet[i]->drawSpecial(pos, alpha, sync, colorpos);
            }
        }
        else
        {
            for (i = 0; i < tilpecount; i++)
            {
                tilpet[i]->draw(pos, alpha, sync, colorpos);
            }
        }
    }
}

void SivuttainTilpe::draw(float pos, float alpha, float analval, float colorpos)
{
    float t = Math::calcSaturate(pos, this->st, this->et, 1.15f);
    if (t > 0.0001f)
    {
        const float end = t;// * (0.5f + colorpos*0.5f);//(0.5 + (1-colorpos) * 0.5f)*t;
        Vector3 d = this->delta * powf(t, 2.0f);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE);
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DEPTH_TEST);

        glBegin(GL_LINE_STRIP);
        for (float u = 0.0f; u < end; u += 0.025f)
        {
            float a = alpha*0.21f*(Math::calcPosFloat(analval, 0, u));//(0.5f+0.5f*(1-u));
            glColor4f(this->color.x, this->color.y, this->color.z, a);
            glVertex3fv((float *)&(this->curve->getValue(u) + d));
        }
        glEnd();
    }
}
void SivuttainTilpe::drawSpecial(float pos, float alpha, float analval, float colorpos)
{
    float t = Math::calcSaturate(pos, this->st, this->et, 1.15f);
    Vector3 col = this->color * (1-colorpos) + this->color2 * colorpos;
    if (t > 0.0001f)
    {
        Vector3 d = this->delta * powf(t, 2.0f);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE);
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_DEPTH_TEST);

        glBegin(GL_LINE_STRIP);
        const float start = t - 0.1f;
        if (start > 0.0f)
        {
            for (float u = t - 0.1f; u < t; u += 0.025f)
            {
                float a = alpha*0.5f*(Math::calcPosFloat(analval, 0, u));//(0.5f+0.5f*(1-u));
                glColor4f(col.x, col.y, col.z, a);
                glVertex3fv((float *)&(this->curve->getValue(u) + d));
            }
        }
        glEnd();
    }
}




/////////////////////////////////////////////////////////////////////////////
///                          SivuttainAlkuotus
/////////////////////////////////////////////////////////////////////////////


void SivuttainAlkuotus::init()
{
    const float xdim = 15.0f;
    const float ydim = 8.0f;
    const float zdim = 15.0f;

    Vector3 initialPos = Vector3(Math::randBetween(-xdim, xdim), 
                                 Math::randBetween(0, ydim),
                                 Math::randBetween(-zdim, zdim));

    this->movement.setUseBounds(true);
    this->movement.setPosition(initialPos);
    this->movement.setDirection(Math::randBetween(0, 2*3.141592f), Math::randBetween(0, 2*3.141592f));
    this->movement.setBoundLimits(-xdim, xdim, -ydim, ydim, -zdim, zdim);
    this->movement.setTurning(0, 0);
    this->movement.setSpeed(Math::randBetween(0.0205f, 0.027f));

    const float harmaa = Math::randBetween(0.3f, 0.5f);
    this->color = Vector3(harmaa, harmaa, harmaa);//0.3f, 0.3f, Math::randBetween(0.4f, 0.7f));
    this->phase = Math::randFloat();
    this->phasespeed = Math::randBetween(0.01f, 0.02f);

    this->glow = Math::randFloat();
    this->glowspeed = Math::randBetween(0.015f, 0.035f);
}

void SivuttainAlkuotus::turn()
{
}

void SivuttainAlkuotus::draw(float alpha)
{
    glColor4f(this->color.x, this->color.y, this->color.z, alpha * (0.6f + 0.4f * sinf(this->phase)));
    Vector3 &p = this->movement.getPosition();
    glVertex3fv((float *)&p);
}
void SivuttainAlkuotus::drawLine(float alpha)
{
    glColor4f(this->color.x, this->color.y, this->color.z, alpha * (0.6f + 0.4f * sinf(this->phase)));
    glVertex3fv((float *)&this->movement.getPosition());
    glVertex3fv((float *)&this->movement.getPreviousPosition());
}
void SivuttainAlkuotus::drawGlow(float alpha, Vector3 &xr, Vector3 &yr, Vector3 &zr)
{
    float g = sinf(this->glow*2*3.141592f);
    const float cutoff = 0.5f;
    if (g > cutoff)
    {
        const float size = Math::calcPosFloat(g, cutoff, 1.0f)*0.2f;
        Vector3 p = this->movement.getPosition();
//        const float size = 0.4f;
        Vector3 v1 = p - xr *size - yr * size;
        Vector3 v2 = p + xr *size - yr * size;
        Vector3 v3 = p + xr *size + yr * size;
        Vector3 v4 = p - xr *size + yr * size;

        glColor4f(this->color.x, this->color.y, this->color.z, alpha * (0.6f + 0.4f * sinf(this->phase)));
        glTexCoord2f(0, 0);
        glVertex3fv((float *)&v1);
        glTexCoord2f(1, 0);
        glVertex3fv((float *)&v2);
        glTexCoord2f(1, 1);
        glVertex3fv((float *)&v3);
        glTexCoord2f(0, 1);
        glVertex3fv((float *)&v4);
    }
}


void SivuttainAlkuotus::update()
{
    this->movement.update();
    if (Math::randFloat() < 0.01f)
    {
        this->movement.selectNewDirection();
    }

    this->phase += this->phasespeed;
    this->glow += this->glowspeed;
}


///////////////////////////////////////////////////////////////////////////////////////////
///                                     EFEKTI
///////////////////////////////////////////////////////////////////////////////////////////

void Sivuttain::renderScene(float pos, float alpha)
{
    pos = Math::calcPosFloat(pos, 0, 0.86f);

    std::vector<SivuttainAlkuotus>::iterator it;
    std::vector<SivuttainOtus *>::iterator it2;

    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (it = alkuotukset.begin(); it < alkuotukset.end(); it++)
        {
            (*it).update();
        }
        this->frametimer->endStep();
    }

    CatmullRom *spline = mastersplinet[0];
    Vector s = spline->getValue(pos);
	float f_ = (pos+0.02f+0.04f*sinf(pos*10));
    if (f_ > 1.0f)
        f_ = 1.0f;
    if (f_ < 0.0f)
        f_ = 0.0f;

	Vector s2 = spline->getValue( f_ > 1.0f ? 1.0f : f_ );
    Matrix rot2;
    rot2.makeRotation(pos*5.0f, 0, -pos*2.5f*powf(sinf(pos*6.0f), 2));

	Vector p = s + (s2 - s)*0.5f;
    //Vector displace = (Vector(0.931f*cosf(pos*11), 0.621f*cosf(pos*15)+0.02f*cosf(pos*6), 2.7f+1.1f*cosf(pos*19))*-1)*rot2;

    //Vector cam = p - displace*(2.0f+0.25f*sinf(pos*5.0f));
	//Vector cam = p + campos->getValue(pos);
	Vector cam = cambase->getValue(pos) + campos->getValue(pos);
    cam.z -= powf(sinf(Math::calcPosFloat(pos, 0.8f, 1.0f)*3.141592f*0.5f), 1.6f)*0.9f;

    Vector tgt = s;
    tgt += Vector(cosf(pos*16), sinf(pos*11), cosf(pos*8))*0.23f;
    Vector upw = Vector(0, 1, 0);

    Matrix rot;
    rot.makeRotation(0, 0, -pos*5*cosf(pos*9));
    upw *= rot;

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, 
			  tgt.x, tgt.y, tgt.z, 
			  upw.x, upw.y, upw.z);

/*
    glLoadIdentity();
    cameras->useCamera(0);

    Vector3 cam = Vector(0, 0, -10);
    Vector3 tgt = Vector(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);
    gluLookAt(cam.x, cam.y, cam.z, 
			  tgt.x, tgt.y, tgt.z, 
			  upw.x, upw.y, upw.z);
  */  
    static float anal_cum = 0.0f;
    float analval = 0.1f*anal->get();

    anal_cum = anal_cum * 0.8f + analval * 0.2f;
    analval = anal_cum;

    filter.init(true);

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDisable(GL_TEXTURE_2D);
    glColor4f(1,0.2f,0.2f,1);
    glDisable(GL_DEPTH_TEST);

    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);

    const float af = 1 - Math::calcPosFloat(pos, 0.98f, 1.0f);

    for (it2 = this->otukset.begin(); it2 < this->otukset.end(); it2++)
    {
        SivuttainOtus *o = *it2;
        o->draw(pos, analval, alpha*af);
    }

    glDisable(GL_LINE_SMOOTH);




    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);

    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDisable(GL_TEXTURE_2D);
    glEnable(GL_LINE_SMOOTH);

    const float viewdist = 10.0f;
    const float foglength = 3.0f;
	float fogcol[] = {0,0,0,1};
	glFogi(GL_FOG_MODE, GL_LINEAR); //EXP, EXP2, LINEAR
	glFogfv(GL_FOG_COLOR, fogcol);
	glFogf(GL_FOG_DENSITY, 0.4f);//+0.4f*(float)cos(aika*10));
	glHint(GL_FOG_HINT, GL_DONT_CARE);
	glFogf(GL_FOG_START, viewdist-foglength);
	glFogf(GL_FOG_END, viewdist);
	glEnable(GL_FOG);

 
    glBegin(GL_LINES);
    for (it = alkuotukset.begin(); it < alkuotukset.end(); it++)
    {
        (*it).drawLine(alpha);
    }
    glEnd();

    
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_white.jpg")->getID());
    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);
    glDisable(GL_DEPTH_TEST);
    glBegin(GL_QUADS); 
    for (it = alkuotukset.begin(); it < alkuotukset.end(); it++)
    {
        (*it).drawGlow(alpha, xr, yr, zr);
    }
    glEnd();
    
    std::vector<Kaartuva>::iterator kit;

	for (kit = kaartuvat.begin(); kit < kaartuvat.end(); kit++)
	{
        Kaartuva &k = *kit;
		float t = Math::calcPosFloat(pos, k.st, k.et);

		if (t > 0.0001f && t < 1.0f)
		{
			glDisable(GL_TEXTURE_2D);
			glBegin(GL_LINE_STRIP);

			const float matka = 0.3f;

			for (float t2=0.0f;t2<matka;t2+=0.02f)
			{
				float t3 = t + t2;
				float a = k.a1*(1-t3) + k.a2*t3;
				float b = k.b1*(1-t3) + k.b2*t3;
				Vector p = k.pos + Math::sphereToCartesian(k.r, a, b);
				glColor4f(1,1,1,alpha*(float)sin(t*3.141592f)*(t2)*2);
				glVertex3fv((float *)&p);
			}

			glEnd();
			glColor4f(1,1,1,(float)sin(t*3.141592f)*analval);
			glEnable(GL_TEXTURE_2D);
			Vector valopos = k.pos + Math::sphereToCartesian(k.r, 
						k.a1*(1-(t+matka)) + k.a2*(t+matka),
						k.b1*(1-(t+matka)) + k.b2*(t+matka));

		}
	}   


    glDisable(GL_FOG);
    glDisable(GL_LINE_SMOOTH);
    glDisable(GL_POINT_SMOOTH);

    filter.drawNoiseOverlay(alpha * 0.1f);
}



Sivuttain::Sivuttain()
{	
    anal = new Analyzer(3);

}

Sivuttain::~Sivuttain()
{
}


bool Sivuttain::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;

    int i, j;

#ifdef NOT_FINAL_SIVUTTAIN

	otukset.clear();
	alkuotukset.clear();
	mastersplinet.clear();

#endif

//    srand(696969);
    srand(0x666);

    const int otuscount = 7;
    const int specialcount = 5;

//    dmsMsg("Sivuttain::init 1\n");
    for (j = 0; j < otuscount; j++)
    {
        const int masterpoints = 120;
	    CatmullRom *masterspline = new CatmullRom();
	    masterspline->startCreation();

        //eka spline ohjaa kameraa yms
        if (j == 0)
        {
            Vector3 startpoint = Math::randVectSphere()*2.0f;//Vector(0, 0, 0);
            float angle = 0.7f;
            for (i = 0; i < masterpoints; i++)
            {
                float it = i / (float)masterpoints;
                masterspline->addPoint(startpoint);

                startpoint += Vector(cosf(angle), sinf(angle), -0.1f)*0.5f;

                float angledelta = 0.0f;
                while (fabsf(angledelta) < 0.4f)
                {
                    angledelta = Math::randBetween(-0.4f, 0.8f);
                }
                angle += angledelta;
            }
        }
        else
        {
            const float maxdist = 0.6f;
            for (i = 0; i < masterpoints; i++)
            {
                float t = i / (float)masterpoints;
                Vector3 d = Math::randVectSphere() * maxdist * powf(Math::randFloat(), 2);
                Vector3 base = mastersplinet[0]->getValue(t);
                masterspline->addPoint(base + d);
            }

        }
	    masterspline->endCreation();
        this->mastersplinet.push_back(masterspline);
    }
//    dmsMsg("Sivuttain::init 2\n");

    for (i = 0; i < otuscount; i++)
    {
        SivuttainOtus *otus = new SivuttainOtus(mastersplinet[i], (i >= otuscount - specialcount) ? true : false, i);
        this->otukset.push_back(otus);
    }
//    dmsMsg("Sivuttain::init 3\n");

    this->frametimer = new FrameTimer(1000 / 60, 5);
//    dmsMsg("Sivuttain::init 4\n");
    for (i = 0; i < 3000; i++)
    {
        SivuttainAlkuotus otus;
        otus.init();
        const float dim = 10.0f;
//        otus.getMovement()->setBoundLimits(-dim, dim, -dim, dim, -dim, dim);
        this->alkuotukset.push_back(otus);
    }

//    dmsMsg("Sivuttain::init 5\n");

	// 0.9 == ok
	srand(0.26f*1000.0f);
//    dmsMsg("Sivuttain::init 6\n");

	campos = new CatmullRom();
    campos->startCreation();
	for(i=0; i<8; i++)
	{
		Vector3 v = Math::randVectSphere() * Math::randFloat()*((3.85f+1.2f*(i+2%3)/3.0f));
		campos->addPoint(v);
	}
	campos->endCreation();
//    dmsMsg("Sivuttain::init 7\n");

	cambase	= new CatmullRom();
    cambase->startCreation();
	for(i=0; i<3; i++)
	{
		Vector3 v = Math::randVectSphere() * Math::randFloat()*(0.3f);
		cambase->addPoint(v);
	}
	cambase->endCreation();
//    dmsMsg("Sivuttain::init 8\n");

    const int kaartuvacount = 800;
    for (i = 0; i < kaartuvacount; i++)
    {
        Kaartuva k;
        k.st = 0.4f + powf(Math::randFloat(), 2.0f) * 0.3f;
		k.et = k.st + 0.03f + 0.02f*Math::randFloat();
		
		k.pos = Math::randVector() * 10;

		k.r = 0.3f + Math::randFloat()*1.0f;
		k.a1 = Math::randFloat()*2*3.141592f;
		k.a2 = Math::randFloat()*2*3.141592f;
		k.b1 = Math::randFloat()*2*3.141592f;
		k.b2 = Math::randFloat()*2*3.141592f;

        this->kaartuvat.push_back(k);
    }

	return true;
}

