#ifdef _DEBUG
	#include <stdlib.h>
	//#include "../mmgr.h"
#endif

#include <math.h>

#include "Suihkeet.h"
#include "../Mathematics.hpp"
#include "../primitives.hpp"

extern void setClearColor(Vector3 color);

// lifetime of particle
const float maxlifetime = 8500;
const float invmaxlifetime = 1.0f/maxlifetime;

void Suihkeet::draw()
{
	setClearColor(Vector3(0,0,0));

	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.125f;
	const float fadeoutstart = 0.95f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

	filter.init();
		renderScene(pos, 1.0f);
	filter.radialblur();

}

void Suihkeet::renderScene(float pos, float alpha)
{
    this->frametimer->update();
	while (this->frametimer->stepsLeft())
    {
		this->frametimer->endStep();
    }


	
	std::vector<SuihkeetP>::iterator it;

	glLoadIdentity();
	
	float wavemod = sinf(dmsGetModulePosition()*0.001f)*0.02f;

   Vector cam = Vector(0, 0, 45-pos*25);
    Vector tar = Vector(0, 0, 0);
    Vector rot = Vector(0, 1, 0);
    gluLookAt(cam.x, cam.y, cam.z, 
              tar.x, tar.y, tar.z, 
              rot.x, rot.y, rot.z);


	//cameras->useCamera(0);

	glDisable(GL_TEXTURE_2D);

	glColor4f(1,1,1,alpha*0.4f);

	const float particle_pos = pos;
	
	// calc times

	float dt;
	if(lastTime < 0)
	{
		lastTime = (float)dmsGetModulePosition();
		lastAdd = 0.01f;
		dt = 0;
	} else {
		dt = dmsGetModulePosition() - lastTime;
		lastTime = (float)dmsGetModulePosition();
	}
	
	float ip;
	ip = particle_pos;

	// add & run
	const float addinterval = 30.0f; // milliseconds

	
	int n;
	if(lastAdd-dt<0) 
	{
		//if(pos>0.01f)
		for(n=0; n<1; n++) 
		{
			SuihkeetP a;
			a.init(spl1->getValue(ip), (spl1->getTangent(ip)).normalize(), maxlifetime);
			suihkelista.push_back(a);
			
			SuihkeetP b;
			b.init(spl2->getValue(ip), (spl2->getTangent(ip)).normalize(), maxlifetime);
			suihkelista.push_back(b);
			
			SuihkeetP c;
			c.init(spl3->getValue(ip), (spl3->getTangent(ip)).normalize(), maxlifetime);
			suihkelista.push_back(c);
			
			SuihkeetP d;
			d.init(spl4->getValue(ip), (spl4->getTangent(ip)).normalize(), maxlifetime);
			suihkelista.push_back(d);
			
			SuihkeetP e;
			e.init(spl5->getValue(ip), (spl5->getTangent(ip)).normalize(), maxlifetime);
			suihkelista.push_back(e);
		}
		lastAdd = addinterval;

	} else lastAdd-=dt;

	Vector3 x, y, z;
	Math::antiRotate(&x, &y, &z);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glDisable(GL_DEPTH_TEST);	

	glColor4f(0.13f,	0.35f,	0.55f, 0.0245f*alpha);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("circle.jpg")->getID());

    static float anal_cum = 0.0f;
    float analval = 0.1f*anal->get();

    anal_cum = anal_cum * 0.8f + analval * 0.2f;
    analval = anal_cum;


    int count = 0;
	glBegin(GL_QUADS);
		for (it = suihkelista.begin(); it != suihkelista.end(); it++)
		{
			{

				if(!(*(it)).update(x,y,z, dt, alpha, analval))
				{
					suihkelista.erase(it);
				}	
			}
		}
	glEnd();

	//glBindTexture(GL_TEXTURE_2D, dmsGetTexture("circle_alpha.png")->getID());
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_DEPTH_TEST);
	float size = 0.5f;
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(0, 0, 0, 1);

		glPushMatrix();
			
			glLoadIdentity();
		
		
			Vector3 disp = Vector3(0.53f, 0.55f, 0.31f);//tool->getColor("color1");
			disp = disp - Vector3(0.5f, 0.5f, 0.5f);
			disp *= 250.0f;
			glTranslatef(disp.x, disp.y, disp.z);

			glScalef(0.1f,0.1f,0.1f);
			
			glRotatef(pos*35.0f+105, -0.64f+sin((1-pos*pos*pos*pos)*2.0f), -0.34f*sinf(pos*4.2f*pos), 0.7f*pos*pos);
			//glRotatef(pos*235.0f+175, 1,0,0);


				int objectvertexcount		= model->model->getVertexCount();
				int objectfacecount			= model->model->getFaceCount();
				T3DFace *objectfaces		= model->model->getFaceArray();
				T3DVertex *objectvertices	= model->model->getVertexArray();
				T3DTBN *tbns				= model->getTBNArray();


				glBegin(GL_TRIANGLES);
					for (int i=0;i<objectfacecount;i++)
					{
						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].a].position);

						
						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].b].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].c].u, objectvertices[objectfaces[i].c].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].c].position);
						
					}
				glEnd();


				/*
				model->computeSilhouette(Vector3() - Vector3(0, 0, 45-pos*25));
				glLineWidth(5);
				glColor3f(1,1,1);
				model->drawSilhouette();
				*/

		glPopMatrix();


	/*
	glBegin(GL_QUADS);
		std::vector<Vector3>::iterator it3;
		for (it3 = stopparilista.begin(); it3 != stopparilista.end(); it3++)
		{
			{
				Vector3 pos = (*(it3));
				
				Vector3 sizexr = x * size;
				Vector3 sizeyr = y * size;
				Vector3 v1 = pos - sizexr - sizeyr;
				Vector3 v2 = pos + sizexr - sizeyr;
				Vector3 v3 = pos + sizexr + sizeyr;
				Vector3 v4 = pos - sizexr + sizeyr;
				
				glTexCoord2f(0,0);
				glVertex3fv((float *)&v1);
				glTexCoord2f(1,0);
				glVertex3fv((float *)&v2);
				glTexCoord2f(1,1);
				glVertex3fv((float *)&v3);
				glTexCoord2f(0,1);
				glVertex3fv((float *)&v4);
				
			}
		}
	glEnd();
	*/

	glColor3f(1,1,1);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

}

Suihkeet::Suihkeet()
{	

}

Suihkeet::~Suihkeet()
{
	delete spl1;
	delete spl2;
	delete spl3;
}

bool Suihkeet::init(unsigned long s, unsigned long e)
{
	
	model = 0;
	model = new T3DVBO(dmsGetObject("3djytky.t3d"));
	model->createVBO();
	model->initializeTBN();
	model->constructEdges();

	spl1 = new CatmullRom();
	spl2 = new CatmullRom();
	spl3 = new CatmullRom();
	spl4 = new CatmullRom();
	spl5 = new CatmullRom();

	srand(15);

	Vector v1 = Vector(0,0,29);
	int i;

	spl1->addPoint((Vector3)v1+Math::randVector(128.0f, 128.0f, 0.0f));
	spl2->addPoint((Vector3)v1+Math::randVector(128.0f, 128.0f, 0.0f));
	spl3->addPoint((Vector3)v1+Math::randVector(128.0f, 128.0f, 0.0f));
	spl4->addPoint((Vector3)v1+Math::randVector(128.0f, 128.0f, 0.0f));
	spl5->addPoint((Vector3)v1+Math::randVector(128.0f, 128.0f, 0.0f));

	for(i=0; i<10; i++)
	{
		spl1->addPoint((Vector3)v1+Math::randVector(8.0f, 8.0f, 2.5f));
		spl2->addPoint((Vector3)v1+Math::randVector(8.0f, 8.0f, 2.5f));
		spl3->addPoint((Vector3)v1+Math::randVector(8.0f, 8.0f, 2.5f));
		spl4->addPoint((Vector3)v1+Math::randVector(8.0f, 8.0f, 2.5f));
		spl5->addPoint((Vector3)v1+Math::randVector(8.0f, 8.0f, 2.5f));
		v1 -= Vector(0,0,2);
	}
	spl1->addPoint(Vector3());
	spl2->addPoint(Vector3());
	spl3->addPoint(Vector3());
	spl4->addPoint(Vector3());
	spl5->addPoint(Vector3());

	spl1->endCreation();
	spl2->endCreation();
	spl3->endCreation();
	spl4->endCreation();
	spl5->endCreation();

	lastTime = -1;
	lastAdd = -1;


	srand(23);
	const float D = 16.0f;
	for(i=0; i<65; i++)
	{
		Vector3 p;
		p = v1 + Math::randVector(D, D, 2.5f);
		stopparilista.push_back(p);
	}

	this->frametimer = new FrameTimer(1000 / 60.0f, 15);
    this->anal = new Analyzer(3);


	startTime = s;
	endTime = e;
	return true;
}



// partikkeli
// not used
SuihkeetP::~SuihkeetP() {};
SuihkeetP::SuihkeetP() {}

// use this 
void SuihkeetP::init(Vector pos, Vector dir, float lt)
{
	this->pos = pos + Math::randVector()*0.5f;
	this->dir = dir + Math::randVector();
	this->dir *= Math::randBetween(0.50f, 3.0f);
	this->lifetime = lt;
    this->type = (Math::randFloat() > 0.7f) ? 1 : 0;
    this->size = Math::randBetween(0.5f, 1.0f);
    this->fade = Math::randBetween(0.7f, 1.0f);

}

// antirotate vektori
bool SuihkeetP::update(Vector x, Vector y, Vector z, float dt, float alpha, float sync)
{

	this->lifetime -= dt;

	// move

	this->pos += this->dir * dt*0.001f;

	this->dir -= this->dir * dt*0.0001f;


	float s = this->lifetime*invmaxlifetime * this->size;
	s *=  0.50f;

	Vector3 sizexr = x * s;
	Vector3 sizeyr = y * s;
	Vector3 v1 = pos - sizexr - sizeyr;
	Vector3 v2 = pos + sizexr - sizeyr;
	Vector3 v3 = pos + sizexr + sizeyr;
	Vector3 v4 = pos - sizexr + sizeyr;
	
    Vector3 color1 = Vector3(0.13f,	0.35f,	0.55f);
    Vector3 color2 = Vector3(0.53f,	0.53f,	0.45f);
    const float syncmul = 1.5f;
    const float synkki = (sync * syncmul) > 1.0f ? 1.0f : (sync * syncmul);
    
    Vector3 col2 = color1 + (color2 - color1) * synkki;

    if (this->type ==0)
    {
        glColor4f(color1.x, color1.y, color1.z, 0.0445f*alpha*this->fade);
    }
    else
    {
        glColor4f(col2.x, col2.y, col2.z, 0.0445f*alpha*this->fade);
    }

	glTexCoord2f(0,0);
	glVertex3fv((float *)&v1);
	glTexCoord2f(1,0);
	glVertex3fv((float *)&v2);
	glTexCoord2f(1,1);
	glVertex3fv((float *)&v3);
	glTexCoord2f(0,1);
	glVertex3fv((float *)&v4);
	
	if(this->lifetime < 0) 
		return false;
	else 
		return true;

}