#ifndef _Suihkeet_HPP_
#define _Suihkeet_HPP_

#include <stdio.h>
#include "../externs.hpp"

class SuihkeetP 
{
public:
	SuihkeetP();
	~SuihkeetP();
	void init(Vector pos, Vector dir, float lifetime);
	bool update(Vector x, Vector y, Vector z, float dt, float alpha, float sync);

private:
	Vector3 pos;
	Vector3 dir;
	float lifetime;	
    float size;
    float fade;
    int type;
};

class Suihkeet : public Base
{
	public:

		Suihkeet();
		~Suihkeet();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
		FrameTimer *frametimer;
		void renderScene(float pos, float alpha);

		CatmullRom *spl1;	
		CatmullRom *spl2;	
		CatmullRom *spl3;	
		CatmullRom *spl4;	
		CatmullRom *spl5;	
		//Lista *list;
		//std::vector<class SuihkeetP> suihkelista;
		std::vector<class SuihkeetP> suihkelista;
		
		std::vector<class Vector3> stopparilista;

		float lastTime;
		float lastAdd;

		T3DVBO *model;
        Analyzer *anal;

};

#endif