#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Tyonto.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

extern void setClearColor(Vector3 color);

void Tyonto::draw()
{
	setClearColor(Vector3(0,0,0));

	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.96f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);


//	Vector3 bg = Vector3(0.09f, 0.1845f, 0.2969f) * alpha * 0.5f;
//	Primitives::flatTausta(bg.x, bg.y, bg.z, alpha*0.4f);


	renderScene(pos, alpha);
 //   filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
	//filter.applychrome(10);
	//filter.dof();
	//float z = tool->getValue("slider2")*0.01f;
	//filter.blur(1, z, z);
}

void Tyonto::renderScene(float pos, float alpha)
{
 
	int i;

    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
		Vector3 d;
		for(i=0; i<obuCount; i++)
		{
			d = obut[i].origpos - obut[i].pos;
			float dsqr = d.x*d.x + d.y*d.y + d.z*d.z;
			if(dsqr > 1.0f)
			{
				d = d.normalize();
				obut[i].pos += d * 0.00035f * dsqr * dsqr;
			}

			// verlet step
			Vector3 tmp = obut[i].pos;
			obut[i].pos += ((obut[i].pos - obut[i].oldpos)*0.997f);
			obut[i].oldpos = tmp;
		}
		

		for(i=0; i<tyontoObuCount; i++)
		{

			tyontoobut[i].pos += tyontoobut[i].dir * tyontoobut[i].speed * 0.40528f;//tool->getValue("slider3")*0.1f;

			if(tyontoobut[i].pos.x < -100 || tyontoobut[i].pos.x > 100 
			|| tyontoobut[i].pos.y < -100 || tyontoobut[i].pos.y > 100 
			|| tyontoobut[i].pos.z < -100 || tyontoobut[i].pos.z > 100)
			{
				tyontoobut[i].pos = Math::randVector()*50.0f;
			}

			push(tyontoobut[i].pos, tyontoobut[i].radius);
		}

        this->frametimer->endStep();
    }

	float pppp = pos*0.3f;
	Vector3 cameraPosition = Vector3(0,25,0) + Vector3(0,-25,0)*pos;
	cameraPosition += Math::sphereToCartesian(1.5f, sin(pppp*4.3f)+sin(powf(pppp,2)), powf(cosf(pppp*4.2f),3));
	Vector3 target = Vector3(0,25,0) + Math::sphereToCartesian(2.575f, sin(pppp*1.3f), -cosf(pppp*0.9f))*pos*pos;

	// TODO: out -> turn camera
	//float outmod = Math::calcPosFloat(pos, 0.80f, 1.0f);
	//outmod = outmod * outmod;
	//target += Math::sphereToCartesian(7.0f, outmod*1.3f, 0) * 2.0f;

	glLoadIdentity();
	gluLookAt(cameraPosition.x, cameraPosition.y, cameraPosition.z, 
			target.x, target.y, target.z, 
			0,1,0);

	int objectvertexcount = background->getVertexCount();
	int objectfacecount = background->getFaceCount();
	T3DFace *objectfaces = background->getFaceArray();
	T3DVertex *objectvertices = background->getVertexArray();

filter.init(true);

	glDisable(GL_BLEND);

	glDepthMask(0);
	glPushMatrix();

		Vector3 cball = Vector3(0.27f, 0.28f, 0.474f) * alpha * 0.70f;
		glScalef(41, 14.25f, 41);
		glRotatef(90.0f, 0,0,1);

		const int texturesPerRun = 32*7;
		const float timeperTexture = 1.0f/float(texturesPerRun);
		float timeyli = fmodf(pos, timeperTexture);

		int n = int(pos*texturesPerRun)%32 + 1;
		int next = int(pos*texturesPerRun+1)%32 + 1;
		
		// Haetaan vastaava tekstuuri
		char buf[75];
		sprintf(buf, "cau_0%02d.jpg", n);
		Texture *t1 = dmsGetTexture(buf);
		
		char buf2[75];
		sprintf(buf2, "cau_0%02d.jpg", next);
		Texture *t2 = dmsGetTexture(buf2);
	
		Shader *ss = shaders->getShader("caustic");
		ss->bind(); 

		ss->setUniform1i("caus0", 0);  
		ss->setUniform1i("caus1", 1);

		ss->setUniform1f("causinterp", timeyli/float(timeperTexture));

		ss->setUniform4f("vari", cball.x, cball.y, cball.z, alpha);

		 glActiveTextureARB(GL_TEXTURE0_ARB);
		 glEnable(GL_TEXTURE_2D);
		 glBindTexture(GL_TEXTURE_2D, t1->getID());
			//glBindTexture(GL_TEXTURE_2D, t->getID());

		 glActiveTextureARB(GL_TEXTURE1_ARB);
		 glEnable(GL_TEXTURE_2D);
		 glBindTexture(GL_TEXTURE_2D, t2->getID());
				
		glBegin(GL_TRIANGLES);
		for (i=0;i<objectfacecount;i++)
		{
			glTexCoord2f(objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
			glVertex3fv((float *)&objectvertices[objectfaces[i].a].position);
			glTexCoord2f(objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
			glVertex3fv((float *)&objectvertices[objectfaces[i].b].position);
			glTexCoord2f(objectvertices[objectfaces[i].c].u	, objectvertices[objectfaces[i].c].v);
			glVertex3fv((float *)&objectvertices[objectfaces[i].c].position);
		}
		glEnd();
		
	ss->unbind();

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);

	glPopMatrix();
	glDepthMask(1);


	Shader *s = shaders->getShader("tyonto");
	s->bind();
	s->setUniform1i("tex", 0);
	float zMod = 0.07f * 500.0f * 0.9f * (1-Math::calcPosFloat(pos, 0.95f, 1.0f));
	 s->setUniform1f("zMod", zMod*alpha);
	//s->setUniform3f("camPos", cameraPosition.x, cameraPosition.y, cameraPosition.z);

	glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	glColor3f(0.55f, 0.95f, 1.0f);

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

	Vector3 color = Vector3(0.19f, 0.34f, 0.64f);//tool->getColor("color4");
	glColor4f(color.x,  color.y, color.z, pos*0.4);
	float sizedefo = 0.1f;
	float sizemod = 0.18f;
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("circle.jpg")->getID());
	//glBindTexture(GL_TEXTURE_2D, dmsGetTexture("bubble1.jpg")->getID());
    glBegin(GL_QUADS);
	Vector3 p;
	int bound1 = obuCount/4;
     float size;
    
	float modi = 0.6f;
	glColor3f(0.6f*modi, 0.3f*modi, 0.3f*modi);
	for(i=0; i<obuCount; i++)
	{
		if(i == bound1) glColor3f(0.3f*modi, 0.6f*modi, 0.7f*modi);
		//else 

		size = sizedefo + ((obuCount&128)*sizemod*0.0078f);
		
		p = obut[i].pos;
		//glVertex3fv((float*)&p);
		Vector3 sizexr = xr * size;
		Vector3 sizeyr = yr * size;
		Vector3 v1 = p - sizexr - sizeyr;//xr * -size + yr * -size;
		Vector3 v2 = p + sizexr - sizeyr;//+ xr *  size + yr * -size;
		Vector3 v3 = p + sizexr + sizeyr;//xr *  size + yr *  size;
		Vector3 v4 = p - sizexr + sizeyr;//xr * -size + yr *  size;

		
		glTexCoord2f(0, 0);
		glVertex3fv((float *)&v1);
		glTexCoord2f(1, 0);
		glVertex3fv((float *)&v2);
		glTexCoord2f(1, 1);
		glVertex3fv((float *)&v3);
		glTexCoord2f(0, 1);
		glVertex3fv((float *)&v4);
    
	}
    glEnd();
	s->unbind();

filter.glow(6, 0.008f, 0.008f, 0.85f , -1.0f, 1.0f); 
}

void Tyonto::push(Vector3 pos, float radius)
{
	float dsq;
	float r2 = radius*radius;
	float invr2 = 1.0f / r2;
	Vector d;
	for(int i=0; i<obuCount; i++)
	{
		d = obut[i].pos - pos;
		dsq = d.x*d.x + d.y*d.y + d.z*d.z;
		if(dsq < r2)
		{
			// push
			d.normalize();
			obut[i].pos += (d * radius) * (dsq * dsq * invr2) * 0.0000015;
		}
	}
}

Tyonto::Tyonto()
{	
    this->frametimer = new FrameTimer(1000 / 60, 5);
}

Tyonto::~Tyonto()
{
}


bool Tyonto::init(unsigned long s, unsigned long e)
{	
	srand(23);
		
	
	//const float worldScale = 50.0f;
	Vector worldScale = Vector(30,70,30);

	int i;
	tyontoObuCount = 5;
	tyontoobut = new TyontoObu[tyontoObuCount];
	for(i=0; i<tyontoObuCount; i++)
	{
		tyontoobut[i].dir = Math::randVector()*2.0f;
		tyontoobut[i].pos = Math::randVector(worldScale.x, worldScale.y, worldScale.z);
		tyontoobut[i].radius = 16.0f;//Math::randBetween(2, 10);
		tyontoobut[i].speed = Math::randBetween(10, 50)*0.5f;
	}

	obuCount = 10000;
	obut = new TObu[obuCount];

	Vector3 p;
	for(i=0; i<obuCount; i++)
	{
		p = Math::randVector(worldScale.x, worldScale.y, worldScale.z);
		if(p.y < 0) p.y = -p.y;
		obut[i].pos = p;
		obut[i].oldpos = p;
		obut[i].origpos = p;
	}


	this->background = dmsGetObject("sp.t3d");
	int objectvertexcount = background->getVertexCount();
	int objectfacecount = background->getFaceCount();
	T3DFace *objectfaces = background->getFaceArray();
	T3DVertex *objectvertices = background->getVertexArray();
	for (i=0;i<objectvertexcount;i++)
	{
		objectvertices[i].u *= 9.0f;
		objectvertices[i].v *= 9.0f;
	}

	startTime = s;
	endTime = e;
	return true;
}

