#ifndef _Uppo_HPP_
#define _Uppo_HPP_

#include <stdio.h>
#include <list>
#include "../externs.hpp"
#include "../bpm.hpp"

class UppoCamera
{
public:
    void init();
    void use();
    void update();
    Vector3 position;
    Vector3 target;
    float time;

};

#define UPPO_STATE_NONE 0
#define UPPO_STATE_BIRTH 1
#define UPPO_STATE_NORMAL 2
#define UPPO_STATE_DYING 3

#define UPPO_TYPE_ANIMAL 1
#define UPPO_TYPE_SPECK 2
#define UPPO_TYPE_SIVU 3
#define UPPO_TYPE_PISTE 4

class UppoOtus
{
public:
    void init(UppoCamera &cam, float pos, int type_to_create = UPPO_TYPE_ANIMAL);
    void update(UppoCamera &cam);
    void render(float alpha, Vector3 &xr, Vector3 &yr);
    bool isDead();

    int type;

    Vector3 color;
    Vector3 position;
    int state;
    float stateTimer;
    float stateTimerSpeed;
    float timer;

    Vector3 rotation;
    Vector3 rotationDelta;
    Vector3 direction;
    Texture *texture;
    float sizeX;
    float sizeY;
    float size;
    float sizespeed;
    float visualtimer;
    float fade;



};

class Uppo : public Base
{
	public:

		Uppo();
		~Uppo();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private: 

		void drawModels(float alpha);
		void drawModel(UppoOtus p, float alpha);

        UppoCamera cam;
        std::list<UppoOtus> otukset;
        std::list<UppoOtus> piskut;
        std::list<UppoOtus> sivut;
        std::list<UppoOtus> pisteet;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
		
		//int taustacount;
		//float *taustapos;
};

#endif

 