#ifndef _Vihoviimeinen_HPP_
#define _Vihoviimeinen_HPP_

#include <stdio.h>
#include <list>
#include <vector>
#include <utility>
#include "../externs.hpp"
#include "alkuotukset.h"
#include "../bpm.hpp"
#include "../groundplane.hpp"
#include "../boundedmovement.h"

class ViimeinenKasvi
{
public:
    ViimeinenKasvi() {};
    ~ViimeinenKasvi() {};

    void init();
    void update(float pos);
    void draw(float pos, float alpha);
    void draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha, float sync);


private:
    float t;
    float speed;
    float phase;
    Vector3 valoPosition;
    void drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha);
    float st, et;
    float timer;
    float fade;
    bool matala;

    CatmullRom *path;
    CatmullRom *path2;
    Vector3 position;
    Vector3 color;
};


class Vihoviimeinen : public Base
{
	public:

		Vihoviimeinen();
		~Vihoviimeinen();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private:
        std::vector<Alkuotus> otukset;
        std::vector<float> otukset_st;
        std::vector<float> otukset_et;

        int puucount;
        ViimeinenKasvi *kasvit;

        Analyzer *anal;
        GroundPlane *merenpohja;
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
};

#endif

 