#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Virtaus.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Virtaus::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}



/*

class VirtausSpline
{
public:
    void generate(Vector3 &start, Vector &end);
    void draw(float alpha);

private:
    int nodecount;
    VirtausNode *nodes;
    CatmullRom *spline;
    Vector3 color;
*/


void VirtausSpline::generate(Vector3 &start, Vector3 &end)
{
    int i = 0;
    this->nodecount = 10; //TODO
    this->nodes = new VirtausNode[this->nodecount];
//    this->color = Vector3(Math::randFloat(), Math::randFloat(), Math::randFloat());
    this->color = Vector3(0.6f, 0.8f, Math::randBetween(0.9f, 1.0f));
    this->fade = Math::randBetween(0.6f, 0.8f);
    this->phase = 0.0f;

    for (i = 0; i < this->nodecount; i++)
    {
        float t = i / (float)this->nodecount;
        Vector3 basepos = start + (end - start) * t;

        const float xmax = 0.1f;
        const float ymax = 0.1f;
        const float xspeed = 0.002f;
        const float yspeed = 0.002f;

        Vector3 delta = Vector3(Math::randBetween(-xmax, xmax), Math::randBetween(-ymax, ymax), 0);
        Vector3 speed = Vector3(0, 0, 0);//Vector3(Math::randBetween(-xspeed, xspeed), Math::randBetween(-yspeed, yspeed), 0);
        VirtausNode n;
        n.position = basepos + delta;
        n.startpos = n.position;
        n.speed = speed;

        this->nodes[i] = n;
        if (i == 0)
        {
            this->nodes[i].originaldist = 0.1f;
        }
        else
        {
            this->nodes[i].originaldist = (this->nodes[i].position - this->nodes[i - 1].position).length();
        }
    }

    this->spline = new CatmullRom();
    this->spline->startCreation();

    for (i = 0; i < this->nodecount; i++)
    {
        this->spline->addPoint(this->nodes[i].position);
    }
    this->spline->endCreation();
}

void VirtausSpline::draw(float alpha)
{
    int i = 0;

    const int steps = 100;

    glBegin(GL_LINE_STRIP);
    for (i = 0; i < steps; i++)
    {
        const float t = i / (float)steps;
        Vector3 p = this->spline->getValue(t);
        float f = 0.8f + 0.2f * sinf(t * 15 + this->phase);
        glColor4f(this->color.x, this->color.y, this->color.z, alpha * this->fade * f);
        glVertex3fv((float *)&p);
    }
    glEnd();
    
}

Vector3 virtausturbulence1(Vector3 &pos, float time)
{
    const float totalspeed = 6.0f;
    float x = sinf(pos.x * 15 + time * totalspeed * 6.0f) * 0.4f + 0.6f * cosf(pos.y * 7 - pos.x * 3.3f + time * totalspeed * 2.0f);
    float y = sinf(pos.y * 8 + time * totalspeed * 3.5f) * 0.5f + 0.5f * cosf(pos.x * 6 - pos.y * 7.8f + time * totalspeed * 7.0f);
    return Vector3(x, y, 0);

}

void VirtausSpline::update()
{
    int i = 0;
    this->phase += 0.05f;

    for (i = 0; i < this->nodecount; i++)
    {
        VirtausNode &n = this->nodes[i];
        n.position += n.speed;
        n.speed += virtausturbulence1(n.position, this->phase) * 0.055f;
/*
        if (i > 0)
        {
            Vector3 d = n.position - this->nodes[i - 1].position;
            float l = d.length();
            d.normalize();

            float diff = l - n.originaldist;
            n.position -= d * diff * 0.001f;


        }
*/

        //YK!
        //kunnon fysiikka joskus
        if ((n.position - n.startpos).length() > 0.04f)
        {
            n.speed = Vector3(0, 0, 0);
        }

    }

    Vector3 *splinepoints = this->spline->getPoints();

    for (i = 0; i < this->nodecount; i++)
    {
        splinepoints[i] = this->nodes[i].position;
    }
}


void Virtaus::renderScene(float pos, float alpha)
{
    int i = 0;
    Vector3 cam = Vector3(0, 0, -3 - pos * 1.5f);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (i = 0; i < this->count; i++)
        {
            this->splines[i]->update();
        }
        this->frametimer->endStep();
    }

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);


    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt2.jpg")->getID());
    glEnable(GL_BLEND);
    glEnable(GL_TEXTURE_2D);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glDisable(GL_DEPTH_TEST);

    for (i = 0; i < this->count - 1; i++)
    {
        const int strips = 150;
        float it = i / (float)this->count;

        float v1 = it;
        float v2 = it + 1.0f / (float)this->count;
        
        const float texturefade = 1.0f;

        glBegin(GL_QUAD_STRIP);
        glColor4f(1,1,1,alpha * texturefade);

        for (int j = 0; j < strips; j++)
        {
            const float texturescale = 2.0f;
            float t = j / (float)strips;

            Vector3 p1 = this->splines[i]->spline->getValue(t);
            Vector3 p2 = this->splines[i + 1]->spline->getValue(t);

            float u = t + this->splines[i]->phase * 0.005f;
            glTexCoord2f(u * texturescale, v1 * texturescale);
            glVertex3fv((float *)&p1);
            glTexCoord2f(u * texturescale, v2 * texturescale);
            glVertex3fv((float *)&p2);
            

        }

        glEnd();


    }

    //splinen piirto
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
    glDisable(GL_DEPTH_TEST);
    glLineWidth(2.0f);

    for (i = 0; i < this->count; i++)
    {
        this->splines[i]->draw(alpha);
    }
}




Virtaus::Virtaus()
{	
    int i = 0;
    this->count = 25;

    srand(666);
    this->splines = new VirtausSpline*[this->count];
    for (i = 0; i < this->count; i++)
    {
        float t = i / (float)this->count;

        const float width = 5.0f;
        const float h = (t - 0.5f)*4;

        Vector3 start = Vector3(-width, h, 0);
        Vector3 end = Vector3(width, h, 0);

        this->splines[i] = new VirtausSpline();
        this->splines[i]->generate(start, end);
    }

    this->frametimer = new FrameTimer(1000 / 60, 5);
}

Virtaus::~Virtaus()
{
}


bool Virtaus::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

