#ifndef _Water_HPP_
#define _Water_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"

class WaterEffect
{

public:

	void init(int size);
	void deinit();
	void updateBuffers();
	void uploadDxDy();
	void uploadNormalMap(float str=0.75f);

	int size;
	int *buffer1;
	int *buffer2;
	int *tmpbuffer;

	GLuint dxdyMapTexture;
	unsigned char *dxdyMapData;
	GLuint normalMapTexture;
	unsigned char *normalMapData;
};

class Water : public Base
{
	public:

		Water();
		~Water();

		bool init(unsigned long s, unsigned long e);
		void draw();

	private: 
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
		WaterEffect *watereffu;
		
		T3DVBO *model;
};

#endif

 