#ifndef _GROUNDPLANE_H_
#define _GROUNDPLANE_H_

#include "externs.hpp"

class GroundPlane
{
public:
    GroundPlane(int xsize, int ysize, float size = 10.0f, float texturemul = 1.0f, float ypos = 0.0f);
    ~GroundPlane();

	void renderWithNormalMaps(Texture *texture, Texture *normalmap, Vector3 light, float alpha);
    void render(Texture *texture, float alpha);
    void makeCircularFade(float brightness = 1.0f, float maxdistmultiplier = 1.0f);

    void setupFade();
    void enableFade();
    float *getFade();

    float safeGet(int x, int y);
    void safePut(int x, int y, float value);

    Vector3 *getVertices();
	TTexCoord *getUVs();
	int getXres();
	int getYres();

	static void setFadeColor(Vector3 c)
	{
		fadeColor = c;
	}

private:

	static Vector3 fadeColor;
    bool hasFade;
    int xres, yres;
    Vector3 *vertices;
    TTexCoord *uv;
    float gridSize;
    float *fade;

};


#endif