#include "postproc.hpp"
#include "primitives.hpp"


#define ENABLE_POSTPROC

void PostProc::init(bool clear) {
	glExt.bindTextureFBO1024(glExt.glowTexture1024ID);
	
	if(clear) 
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		

}

void PostProc::drawNoiseOverlay(float alpha)
{
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);	
	glColor4f(1,1,1,alpha);
	glEnable(GL_TEXTURE_2D);
	srand(int(dmsGetModulePosition()/50)); // 50 ms each
	glBindTexture(GL_TEXTURE_2D, glExt.noiseTextures[rand()%25]);

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	float texX = screensizex/512.0f * 2.0f;
	float texY = screensizey/512.0f * 2.0f;

			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(texX, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(texX, texY);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, texY);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	// Takaisin 3d moodiin 
	dmsPerspective3D();

}

void PostProc::glow(int blur_steps, float blur_step_x, float blur_step_y, float blur_brightness, float darken_alpha, float glow_amount, int disable_dir) 
{

	// Rale 10.7.2006
   	glExt.unbindFBO();

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	//glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	Shader *darken = shaders->getShader("darken");

	// Tarkastetaan ett haluttiin darkensheideri kyttn
	if(darken_alpha>=0) 
	{
		
		//shaders.darken->setUniform1f("alpha", darken_alpha);  
		darken->bind();
		glActiveTextureARB(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
		darken->setUniform1i("tex", 0);  
		darken->setUniform1f("alpha", darken_alpha);  

	} else shaders->unbind();

	// Piirretn alkuperinen kuva tummennettuna pikkubufferiin
	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();

	
	if(darken_alpha>=0) {
		shaders->unbind();
	}

	// Rendertargettia pienemmksi

	glExt.bindTextureFBO256(glExt.glowTexture256ID);
			
		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	glExt.unbindFBO();

	glExt.bindTextureFBO128(glExt.glowTexture128ID);
		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture256ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	glExt.unbindFBO();


	Shader *blurx = shaders->getShader("blurx");
	// Seuraavaksi blurrataan pikkubufferikuvaa
	for(int i=0; i<blur_steps; i++) {

		if(disable_dir!=2)
		{
			blurx->bind();
			blurx->setUniform1i("tex", 0);  
			blurx->setUniform1f("xoff", blur_step_x);
			blurx->setUniform1f("alpha", blur_brightness);
		}

			glExt.bindTextureFBO128(glExt.glowTexture128ID2);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture128ID);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		if(disable_dir!=2)
		{
			blurx->unbind();
		}

		Shader *blury = shaders->getShader("blury");

		if(disable_dir!=1)
		{
			blury->bind();
			blury->setUniform1i("tex", 0);  
			blury->setUniform1f("yoff", blur_step_y);
			blury->setUniform1f("alpha", blur_brightness);
		}


			glExt.bindTextureFBO128(glExt.glowTexture128ID);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture128ID2);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();
		
		if(disable_dir!=1)
		{
			blury->unbind();
		}
	}

	/**/

	// blendi plle - ett alphakanavat futaa
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE,GL_ONE);
	glColor4f(1,1,1,1); 

	// Piirretn alkuperinen ja blurrattu yhdess 

	Shader *glowc = shaders->getShader("glowc");
	glowc->bind();		

		glowc->setUniform1f("glow_amount", glow_amount);

		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.glowTexture1024ID);
		glowc->setUniform1i("texunit0", 0);

		glActiveTextureARB(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.glowTexture128ID);
		glowc->setUniform1i("texunit1", 1);

				 glBegin(GL_QUADS);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0, 0);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0, 0);
					glVertex2i(0, 0);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1, 0);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1, 0);
					glVertex2i(screensizex, 0);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1, 1);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1, 1);
					glVertex2i(screensizex, screensizey);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0, 1);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0, 1);
					glVertex2i(0, screensizey);
				 glEnd();   

		glActiveTextureARB(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);
		

	glActiveTextureARB(GL_TEXTURE0);
	shaders->unbind();


  
	/**/

	glEnable(GL_TEXTURE_2D);

	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);


	// Takaisin 3d moodiin 
	dmsPerspective3D();
	//glLoadIdentity();

}

void PostProc::blur(int blur_steps, float blur_step_x, float blur_step_y) {

   	
	glExt.unbindFBO();

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();

	glExt.bindTextureFBO256(glExt.glowTexture256ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();


	Shader *blur2x = shaders->getShader("blur2x");
	Shader *blur2y = shaders->getShader("blur2y");
	// Seuraavaksi blurrataan pikkubufferikuvaa
	for(int i=0; i<blur_steps; i++) 
	{

		blur2x->bind();
		blur2x->setUniform1i("tex", 0);  
		blur2x->setUniform1f("xoff", blur_step_x);
		blur2x->setUniform1f("alpha", 1);

			glExt.bindTextureFBO256(glExt.glowTexture256ID2);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture256ID);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		blur2x->unbind();


		blur2y->bind();
		blur2y->setUniform1i("tex", 0);  
		blur2y->setUniform1f("yoff", blur_step_y);
		blur2y->setUniform1f("alpha", 1);


			glExt.bindTextureFBO256(glExt.glowTexture256ID);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture256ID2);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		blur2y->unbind();
	}

	glEnable(GL_BLEND);
	//glBlendFunc(GL_ONE,GL_ONE);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glColor4f(1,1,1,1); 

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture256ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	/**/

	glEnable(GL_TEXTURE_2D);

	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);


	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();

}

// idea from - http://pages.cpsc.ucalgary.ca/~parker/501/edgedetect.pdf
void PostProc::edge(int blur_steps, float blur_step_x, float blur_step_y, float blur_alpha) {


	glExt.unbindFBO();

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();

/*
	// Seuraavaksi blurrataan pikkubufferikuvaa
	for(int i=0; i<blur_steps; i++) {

		blur2x->bind();
		blur2x->setUniform1i("tex", 0);  
		blur2x->setUniform1f("xoff", blur_step_x);
		blur2x->setUniform1f("alpha", blur_alpha);

			glExt.bindTextureFBO512(glExt.glowTexture512ID2);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		blur2x->unbind();

		blur2y->bind();
		blur2y->setUniform1i("tex", 0);  
		blur2y->setUniform1f("yoff", blur_step_y);
		blur2y->setUniform1f("alpha", blur_alpha);


			glExt.bindTextureFBO512(glExt.glowTexture512ID);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID2);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		blur2y->unbind();
	}*/

	/***/ 

	
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_ONE, GL_ONE);
//	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);	

	Shader *edge = shaders->getShader("edge");
	// nyt meill on blurrattu kuva - vetstn edgefiltteri
	edge->bind();
	edge->setUniform1i("tex", 0);  

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();


	edge->unbind();

	/**/

	glEnable(GL_TEXTURE_2D);

	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);


	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();

}

void PostProc::drawOverlay() {

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();

  
}



void PostProc::initMotionBlur(int frames_delay)
{
	glExt.bindTextureFBO1024(glExt.motionBlur1024);

	float alpha = 1.0f / float(frames_delay);
	glDepthMask(0);
		
		glPushMatrix();
			dmsPerspective2D(1,1);
			glLoadIdentity();
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glDisable(GL_DEPTH_TEST);
			glDisable(GL_TEXTURE_2D);
			glEnable(GL_BLEND);
				
				glColor4f(0.0f, 0.0f, 0.0f, alpha); // ALPHA st blurrin mr 0.5f kytnnss minimi
				glBegin(GL_QUADS);
					glVertex2f(0.0f, 0.0f);
					glVertex2f(1.0f, 0.0f);
					glVertex2f(1.0f, 1.0f);
					glVertex2f(0.0f, 1.0f);			
				glEnd();

			dmsPerspective3D();
			glLoadIdentity();
		glPopMatrix();
	
		glDisable(GL_BLEND);
	
	glDepthMask(1);
	glColor3f(1,1,1);
}

void PostProc::motionBlur()
{
	glExt.unbindFBO();

	glDepthMask(0);
	glPushMatrix();

		glColor3f(1,1,1);	
		// PIIRR KUVA
		dmsPerspective2D(1, 1);
		glLoadIdentity();

		//glEnable(GL_BLEND);
		//glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		glDisable(GL_BLEND);
		glDisable(GL_DEPTH_TEST);

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, glExt.motionBlur1024);
			glBegin(GL_QUADS);
			glTexCoord2i(0, 0);
			glVertex2i(0, 0);
			glTexCoord2i(1, 0);
			glVertex2i(1, 0);
			glTexCoord2i(1, 1);
			glVertex2i(1, 1);
			glTexCoord2i(0, 1);
			glVertex2i(0, 1);
			glEnd();
		dmsPerspective3D();	
		glLoadIdentity();

	glPopMatrix();
	glDepthMask(1);

	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glEnable(GL_BLEND);

	glDisable(GL_TEXTURE_2D);
//	glEnable(GL_BLEND);
//	glEnable(GL_DEPTH_TEST);
}



void PostProc::initDOF(bool clear) 
{
	glExt.bindDepthFBO();
	
	if(clear) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		
}

void PostProc::dof(float nearDist, float focusDist, float farDist, int blur_steps, float blur_step_x, float blur_step_y, float blur_alpha)
{
	// Rale 12.1.2007
   	glExt.unbindFBO();

	glBindTexture(GL_TEXTURE_2D, glExt.depthTex);
	Primitives::textureTausta(0,1);

/*
	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);
	glExt.bindTextureFBO512(glExt.glowTexture512ID);
			
		glBindTexture(GL_TEXTURE_2D, glExt.depthColTex);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	glExt.unbindFBO();

	glExt.bindTextureFBO256(glExt.glowTexture256ID);
			
		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	glExt.unbindFBO();

	glExt.bindTextureFBO128(glExt.glowTexture128ID);
		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture256ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	glExt.unbindFBO();


	Shader *blur2x = shaders->getShader("blur2x");
	Shader *blur2y = shaders->getShader("blur2y");

	// Seuraavaksi blurrataan pikkubufferikuvaa
	for(int i=0; i<blur_steps; i++) {

		blur2x->bind();
		blur2x->setUniform1i("tex", 0);  
		blur2x->setUniform1f("xoff", blur_step_x);
		blur2x->setUniform1f("alpha", blur_alpha);// blur_brightness

			glExt.bindTextureFBO128(glExt.glowTexture128ID2);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture128ID);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		blur2x->unbind();

		blur2y->bind();
		blur2y->setUniform1i("tex", 0);  
		blur2y->setUniform1f("yoff", blur_step_y);
		blur2y->setUniform1f("alpha", blur_alpha); //blur_brightness


			glExt.bindTextureFBO128(glExt.glowTexture128ID);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture128ID2);
					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   
			glExt.unbindFBO();

		blur2y->unbind();
	}

	// nyt glowTexture128ID:ss on blurrattu kuva
	// sheidereill pit yhdist 

	// blendi plle - ett alphakanavat futaa
	glEnable(GL_BLEND);
	//glDisable(GL_BLEND);
	//glBlendFunc(,GL_ONE_);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1,1,1,1); 

	// Piirretn alkuperinen ja blurrattu yhdess 

	Shader *dof = shaders->getShader("dof");

	dof->bind();		

		dof->setUniform1f("near",  nearDist);
		dof->setUniform1f("focus", focusDist);
		dof->setUniform1f("far",   farDist);

		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.depthColTex);
		dof->setUniform1i("texunit0", 0);

		glActiveTextureARB(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.glowTexture128ID);
		dof->setUniform1i("texunit1", 1);

		glActiveTextureARB(GL_TEXTURE2_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.depthTex);
		dof->setUniform1i("texunit2", 2);

				 glBegin(GL_QUADS);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0, 0);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0, 0);
					glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 0, 0);
					glVertex2i(0, 0);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1, 0);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1, 0);
					glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 1, 0);
					glVertex2i(screensizex, 0);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 1, 1);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 1, 1);
					glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 1, 1);
					glVertex2i(screensizex, screensizey);
					glMultiTexCoord2fARB(GL_TEXTURE0_ARB, 0, 1);
					glMultiTexCoord2fARB(GL_TEXTURE1_ARB, 0, 1);
					glMultiTexCoord2fARB(GL_TEXTURE2_ARB, 0, 1);
					glVertex2i(0, screensizey);
				 glEnd();   

		shaders->unbind();

			glActiveTextureARB(GL_TEXTURE2);
			glDisable(GL_TEXTURE_2D);

		glActiveTextureARB(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);
		

	glActiveTextureARB(GL_TEXTURE0);
	shaders->unbind();


	glEnable(GL_TEXTURE_2D);

	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);

	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();
*/
}


void PostProc::coloradjust(float saturate, float brightness, float contrast)
{   	
	glExt.unbindFBO();

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();;
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	Shader *color = shaders->getShader("color");

		glUseProgramObjectARB(color->program);
		glUniform1fARB(glGetUniformLocationARB(color->program, "saturate"), saturate);  
		glUniform1fARB(glGetUniformLocationARB(color->program, "contrast"), contrast);  
		glUniform1fARB(glGetUniformLocationARB(color->program, "brightness"), brightness);  


		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.glowTexture1024ID);
		glUniform1i(glGetUniformLocationARB(color->program, "tex"), 0);


					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   

		glActiveTextureARB(GL_TEXTURE0);
		glUseProgramObjectARB(0);



	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);

	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();
}

void PostProc::sindistortion(float xfreq, float yfreq, float xphase, float yphase, float xamp, float yamp)
{   	
	glExt.unbindFBO();

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();

	Shader *sindistort = shaders->getShader("sindistort");

		glUseProgramObjectARB(sindistort->program);
		glUniform1fARB(glGetUniformLocationARB(sindistort->program, "xfreq"), xfreq);  
		glUniform1fARB(glGetUniformLocationARB(sindistort->program, "yfreq"), yfreq);  
		glUniform1fARB(glGetUniformLocationARB(sindistort->program, "xphase"), xphase);  
		glUniform1fARB(glGetUniformLocationARB(sindistort->program, "yphase"), yphase);
		glUniform1fARB(glGetUniformLocationARB(sindistort->program, "xamp"), xamp);  
		glUniform1fARB(glGetUniformLocationARB(sindistort->program, "yamp"), yamp);  


		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,glExt.glowTexture512ID);
		glUniform1i(glGetUniformLocationARB(sindistort->program, "tex"), 0);


					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   

		glActiveTextureARB(GL_TEXTURE0);
		glUseProgramObjectARB(0);



	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);

	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();

}

void PostProc::applymetafake()
{
	glExt.unbindFBO();


	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_ONE, GL_ONE);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	Shader *meta= shaders->getShader("meta");
		glUseProgramObjectARB(meta->program);
		//glUniform1i(glGetUniformLocationARB(chrome->program, "times"), chrome_times);  
		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);


	glBindTexture(GL_TEXTURE_2D,glExt.glowTexture1024ID);
			
		glUniform1i(glGetUniformLocationARB(meta->program, "tex"), 0);

					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   

		glActiveTextureARB(GL_TEXTURE0);
		glUseProgramObjectARB(0);

	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);

	// Takaisin 3d moodiin 
	dmsPerspective3D();
}

void PostProc::applychrome(int chrome_times)
{
	glExt.unbindFBO();


	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(GL_FALSE);


	
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_ONE, GL_ONE);

	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	Shader *chrome = shaders->getShader("chrome");
		glUseProgramObjectARB(chrome->program);
		glUniform1i(glGetUniformLocationARB(chrome->program, "times"), chrome_times);  
		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);


	glBindTexture(GL_TEXTURE_2D,glExt.glowTexture1024ID);
		
	
		glUniform1i(glGetUniformLocationARB(chrome->program, "tex"), 0);


					 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);
					 glEnd();   

		glActiveTextureARB(GL_TEXTURE0);
		glUseProgramObjectARB(0);

	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);

	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();
}

void PostProc::radialblur()
{
	unsigned int i;
   	glExt.unbindFBO();

	// Haetaan ruudun koko
	int screensizex = dmsGetWindowWidth();
    int screensizey = dmsGetWindowHeight();
	dmsPerspective2D(screensizex, screensizey);
	glLoadIdentity();

	// Poistetaan syvyystestaus ja blendaus kytst
	glDisable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);
	
	glEnable(GL_TEXTURE_2D);

	glColor4f(1,1,1,1);

	
	// Piirretn alkuperinen kuva tummennettuna pikkubufferiin
	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();
	

	glExt.bindTextureFBO512(glExt.glowTexture512ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture1024ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();
/*
	glExt.bindTextureFBO256(glExt.glowTexture256ID);

		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);
			glBegin(GL_QUADS);
				glTexCoord2i(0, 0);
				glVertex2i(0, 0);
				glTexCoord2i(1, 0);
				glVertex2i(screensizex, 0);
				glTexCoord2i(1, 1);
				glVertex2i(screensizex, screensizey);
				glTexCoord2i(0, 1);
				glVertex2i(0, screensizey);			
			glEnd();
	 
	glExt.unbindFBO();
*/
// ---------
    glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
    int count = 5;
	
/*
	float zoomkerroin = 0.1f*tool->getValue("slider3")/(float)count;
	float startalpha = tool->getValue("slider1");
	float alphakerroin = tool->getValue("slider2")/(float)count;
/**/
/**/
	
	const float zoomkerroin = 0.045f/(float)count;
	const float startalpha = 0.28f;
	const float alphakerroin = 0.02f/(float)count;
/**/

	float zoom = zoomkerroin;
    for (i=0; i<count; i++)
    {
        //float zoom = i*zoomkerroin;
		float a = startalpha-(i*alphakerroin);
		 
			glExt.bindTextureFBO512(glExt.glowTexture512ID);
				glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID2);
				glColor3f(a,a,a);

				glBegin(GL_QUADS);
					glTexCoord2f(zoom,		zoom);
					glVertex2i(0,			0);
					glTexCoord2f(1-zoom,	zoom);
					glVertex2i(screensizex, 0);
					glTexCoord2f(1-zoom,	1-zoom);
					glVertex2i(screensizex, screensizey);
					glTexCoord2f(zoom,		1-zoom);
					glVertex2i(0,			screensizey);	
				glEnd();
			glExt.unbindFBO();

		/**/
		
		glColor3f(1,1,1);
		glDisable(GL_BLEND);
		float modizoom = powf(zoom, (float)(i+1)*2);
		glExt.bindTextureFBO512(glExt.glowTexture512ID2);
			glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);

			glBegin(GL_QUADS);
					glTexCoord2f(modizoom,	modizoom);
					glVertex2i(0,			0);
					glTexCoord2f(1-modizoom,modizoom);
					glVertex2i(screensizex, 0);
					glTexCoord2f(1-modizoom,1-modizoom);
					glVertex2i(screensizex, screensizey);
					glTexCoord2f(modizoom,	1-modizoom);
					glVertex2i(0,			screensizey);
			glEnd();
		glExt.unbindFBO();
		glEnable(GL_BLEND);
    }
//	*/

// ---------

	/**/

	glDisable(GL_BLEND);
	//glBlendFunc(GL_ONE,GL_ONE);
	glColor3f(1,1,1); 

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, glExt.glowTexture512ID);

				 glBegin(GL_QUADS);
						glTexCoord2i(0, 0);
						glVertex2i(0, 0);
						glTexCoord2i(1, 0);
						glVertex2i(screensizex, 0);
						glTexCoord2i(1, 1);
						glVertex2i(screensizex, screensizey);
						glTexCoord2i(0, 1);
						glVertex2i(0, screensizey);	
				 glEnd();   

		glDisable(GL_TEXTURE_2D);
		
	shaders->unbind();


  
	/**/

	glEnable(GL_TEXTURE_2D);

	// Syvyystestaus taas plle
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);


	// Takaisin 3d moodiin 
	dmsPerspective3D();
	glLoadIdentity();

}


