#include "shader.hpp"

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <fstream>
#include "config.hpp" // Config::

using namespace std;

//--------------------------------------------------------------------------------------------
//  Static members
//--------------------------------------------------------------------------------------------

bool ShaderManager::createdFlag = false;
ShaderManager *ShaderManager::instance = NULL;

//--------------------------------------------------------------------------------------------
//  Initialize shaders here
//--------------------------------------------------------------------------------------------


void ShaderManager::initShaders() 
{
	// TODO: ADD THESE !
		
			static const char *emptyVertex = {
					"varying vec2 Tex_coord;"\
					"void main(void) "\
					"{"\
					"   gl_Position = ftransform();"\
					"   gl_TexCoord[0] = gl_MultiTexCoord0;"\
					"}"	
			};

			// *** BlurX

			static const char *blurxVertex = {
					"varying vec2 pos0;"\
					"varying vec2 pos1;"\
					"varying vec2 pos2;"\
					"varying vec2 pos3;"\
					"varying vec2 pos4;"\
					"varying vec4 c;"\
					"uniform float xoff;"\
					"void main(void) "\
					"{"\
					"	c = gl_Color;"\
					"   vec2 DX = vec2(xoff,0.0);"\
					"   vec2 DX2 = vec2(2.0*xoff,0.0);"\
		            "   pos0 = gl_MultiTexCoord0.st-DX2;"\
					"   pos1 = gl_MultiTexCoord0.st-DX;"\
					"   pos2 = gl_MultiTexCoord0.st;"\
					"   pos3 = gl_MultiTexCoord0.st+DX;"\
					"   pos4 = gl_MultiTexCoord0.st+DX2;"\
					"   gl_Position = ftransform();"\
					"}"	
			};

			// *** BlurY

			static const char *bluryVertex = {
					"varying vec2 pos0;"\
					"varying vec2 pos1;"\
					"varying vec2 pos2;"\
					"varying vec2 pos3;"\
					"varying vec2 pos4;"\
					"uniform float yoff;"\
					"varying vec4 c;"\
					"void main(void) "\
					"{"\
					"	c = gl_Color;"\
					"   vec2 DX = vec2(0.0, yoff);"\
					"   vec2 DX2 = vec2(0.0, 2.0*yoff);"\
		            "   pos0 = gl_MultiTexCoord0.st-DX2;"\
					"   pos1 = gl_MultiTexCoord0.st-DX;"\
					"   pos2 = gl_MultiTexCoord0.st;"\
					"   pos3 = gl_MultiTexCoord0.st+DX;"\
					"   pos4 = gl_MultiTexCoord0.st+DX2;"\
					"   gl_Position = ftransform();"\
					"}"	
			};

			// *** BlurFragment

			static const char *blurFragment = {
              "uniform sampler2D tex;"\
			  "varying vec2 pos0;"\
			  "varying vec2 pos1;"\
			  "varying vec2 pos2;"\
			  "varying vec2 pos3;"\
			  "varying vec2 pos4;"\
			  "varying vec4 c;"\
              "uniform float alpha;"\
              "void main()"\
              "{"\

              "   vec4 col = vec4(0,0,0,0);"\
              "   col+=texture2D(tex, pos0)*0.1;"\
              "   col+=texture2D(tex, pos1)*0.25;"\
              "   col+=texture2D(tex, pos2)*0.5;"\
              "   col+=texture2D(tex, pos3)*0.25;"\
              "   col+=texture2D(tex, pos4)*0.1;"\
              "   gl_FragColor = col*alpha*c;"\
              "}"
			};

			static const char *blur2Fragment = {
              "uniform sampler2D tex;"\
			  "varying vec2 pos0;"\
			  "varying vec2 pos1;"\
			  "varying vec2 pos2;"\
			  "varying vec2 pos3;"\
			  "varying vec2 pos4;"\
              "uniform float alpha;"\
			  "varying vec4 c;"\
              "void main()"\
              "{"\
              "   vec4 col = vec4(0,0,0,0);"\
              "   col+=texture2D(tex, pos0)*0.1;"\
              "   col+=texture2D(tex, pos1)*0.2;"\
              "   col+=texture2D(tex, pos2)*0.4;"\
              "   col+=texture2D(tex, pos3)*0.2;"\
              "   col+=texture2D(tex, pos4)*0.1;"\
              "   gl_FragColor = vec4(col.rgb, 1)*alpha*c;"\
              "}"
			};

			// *** glow combine

			static const char *glowcVertex = {
				"varying vec2 coord;"\
				"void main(void) "\
				"{"\
				"   coord = gl_MultiTexCoord0.xy;"\
				"   gl_Position = ftransform();"\
				"}"
			};


			static const char *glowcFragment = {
				"uniform sampler2D texunit0;"\
				"uniform sampler2D texunit1;"\
				"uniform float glow_amount;"\
				"varying vec2 coord;"\
				"void main()"\
				"{"\
				"	vec4 norm = texture2D(texunit0, coord);"\
				"	vec4 glow = texture2D(texunit1, coord)*glow_amount;"\
				"	gl_FragColor = norm+glow;"\
				"}"
			};

            // *** invert

			static const char *invertVertex = {
				"varying vec2 coord;"\
				"void main(void) "\
				"{"\
				"   coord = gl_MultiTexCoord0.xy;"\
				"   gl_Position = ftransform();"\
				"}"
			};

            static const char *invertFragment = {
                "uniform sampler2D texunit0;"\
                "uniform float invert_amount ;"\
                "uniform float alpha;"\
                "varying vec2 coord;"\
                "void main()"\
                "{"\
                "   vec4 col = texture2D(texunit0, coord);"\
                "   col.x = col.x * (1.0-invert_amount) + (1.0-col.x) * invert_amount; "\
                "   col.y = col.y * (1.0-invert_amount) + (1.0-col.y) * invert_amount; "\
                "   col.z = col.z * (1.0-invert_amount) + (1.0-col.z) * invert_amount; "\
                "   col *= alpha; "\
                "   gl_FragColor = col;"\
                "}"
            };


			// *** darken 

			static const char *darkenVertex = {
				"varying vec2 coord;"\
				"void main(void) "\
				"{"\
				"   gl_Position = ftransform();"\
				"   coord = gl_MultiTexCoord0.xy;"\
				"}"
			};

			static const char *darkenFragment = {
				"uniform sampler2D tex;"\
				"uniform float alpha;"\
				"varying vec2 coord;"\
				"void main()		"\
				"{"\
				"   vec4 c = texture2D(tex, coord); "\
				"	gl_FragColor = c*c*alpha; "\
				"}"
			};

			// *** 50:50 mix

			static const char *mixVertex = {
				"varying vec2 coord1;"\
				"varying vec2 coord2;"\
				"void main(void) "\
				"{"\
				"   gl_Position = ftransform();"\
				"   coord1 = gl_MultiTexCoord0.xy;"\
				"   coord2 = gl_MultiTexCoord1.xy;"\
				"}"
			};

			static const char *mixFragment = {
				"uniform sampler2D tex1;"\
				"uniform sampler2D tex2;"\
				"varying vec2 coord1;"\
				"varying vec2 coord2;"\
				"void main()		"\
				"{"\
				"   vec4 c = texture2D(tex1, coord1) + texture2D(tex2, coord2); "\
				"	gl_FragColor = c * 0.5; "\
				"}"
			};


			// *** blackwhite

			static const char *bwVertex = {
				"varying vec2 coord;"\
				"void main(void) "\
				"{"\
				"   gl_Position = ftransform();"\
				"   coord = gl_MultiTexCoord0.xy;"\
				"}"
			};

			static const char *bwFragment = {
				"uniform sampler2D tex;"\
				"uniform float threshold;"\
				"varying vec2 coord;"\
				"void main()		"\
				"{"\
				"   vec4 c = texture2D(tex, coord); "\
				"   if( (c.x+c.y+c.z)/3.0 < threshold ) "\
				"	 gl_FragColor = vec4(0,0,0,1); "\
				"	else "\
				"	 gl_FragColor = vec4(1,1,1,1); "\
				"}"
			};

			// *** edge detetion stuff

			// http://en.wikipedia.org/wiki/Sobel
			// tt voi optata siirtmll positiot vertexshaderille
			const char *edgeFragment = {
				"	uniform sampler2D tex;"\
				"	const float off = 1.0 / 512.0;"\
				"	void main()"\
				"	{"\
				/* naapurimatriisi */
				"	vec4 s00 = texture2D(tex, gl_TexCoord[0].xy + vec2(-off, -off));"\
				"	vec4 s01 = texture2D(tex, gl_TexCoord[0].xy + vec2( 0, -off));"\
				"	vec4 s02 = texture2D(tex, gl_TexCoord[0].xy + vec2( off, -off));"\
				"	vec4 s10 = texture2D(tex, gl_TexCoord[0].xy + vec2(-off, 0));"\
				"	vec4 s12 = texture2D(tex, gl_TexCoord[0].xy + vec2( off, 0));"\
				"	vec4 s20 = texture2D(tex, gl_TexCoord[0].xy + vec2(-off, off));"\
				"	vec4 s21 = texture2D(tex, gl_TexCoord[0].xy + vec2( 0, off));"\
				"	vec4 s22 = texture2D(tex, gl_TexCoord[0].xy + vec2( off, off));"\
				/* sobel filtteriarvoja */
				"	vec4 sobelX = s00 + 2.0 * s10 + s20 - s02 - 2.0 * s12 - s22;"\
				"	vec4 sobelY = s00 + 2.0 * s01 + s02 - s20 - 2.0 * s21 - s22;"\
				"	vec4 edgeSqr = vec4(sobelX * sobelX +  sobelY * sobelY);"\
				/* grayscale */
				"	float val = (edgeSqr.x+edgeSqr.y+edgeSqr.z);"\
				/*" if(val > 1.0) val = 1.0; "\*/
				"	gl_FragColor = vec4(val,val,val, val <= 0.0 ? 0.0 : 1.0);"
				/* alpha ?? */
				"}"

			};

			// *** depth of field - blur step selector
			// 

			static const char *dofVertex = {
				"varying vec2 coord;"\
				"void main(void) "\
				"{"\
				"   gl_Position = ftransform();"\
				"   coord = gl_MultiTexCoord0.xy;"\
				"}"
			};

			static const char *dofFragment = {
				/*normal image*/
				"uniform sampler2D texunit0;"\
				/*blurred image*/
				"uniform sampler2D texunit1;"\
				/*depth values*/
				"uniform sampler2D texunit2;"\
				"uniform float near;"\
				"uniform float focus;"\
				"uniform float far;"\
				"varying vec2 coord;"\
				"void main()"\
				"{"\
				"	float f;"\
				"	float depth = texture2D(texunit2, coord).r;"\
				"	if(depth < focus)"\
				"	{"\
				"		f = 1.0 - clamp((depth - near) / (focus - near), 0.0, 1.0); "\
				"	} else {"\
				"		f = clamp((depth - focus) / (far - focus), 0.0, 1.0); "\
				"	}"\
				"	vec4 norm = texture2D(texunit0, coord) * (1.0 - f);"\
				"	vec4 blurred = texture2D(texunit1, coord) * f;"\
				"   gl_FragColor = blurred+norm;"\
				"}"
			};

			// *** Sini distortti
			// 

			static const char *sindistortVertex = {
					"varying vec2 Tex_coord;"\
					"varying vec4 col;"\
					"uniform float alpha;"\
					"void main(void) "\
					"{"\
					"	col = gl_Color*alpha;"\
					"   gl_Position = ftransform();"\
					"   gl_TexCoord[0] = gl_MultiTexCoord0;"\
					"}"	
			};

		static const char *sindistortFragment = {
			"uniform sampler2D tex;"\
			"varying vec4 col;"\
			/*taajuudet*/
			"uniform float xfreq;"\
			"uniform float yfreq;"\
			/*vaihe josta effu alkaa*/
			"uniform float xphase;"\
			"uniform float yphase;"\
			/*amplitudi*/
			"uniform float xamp;"\
			"uniform float yamp;"\
			"void main()"\
			"{"\
			"	float xdiv = 3.14159 * xfreq;"\
			"	float ydiv = 3.14159 * yfreq;"\
			"   float a = yphase+gl_TexCoord[0].x+sin(gl_TexCoord[0].y*xdiv)*xamp;"\
			/*"   if(a<0.0) a+=1.0; else if(a>1.0) a-=1.0;"\ */
			"   float b = xphase+gl_TexCoord[0].y+sin(gl_TexCoord[0].x*ydiv)*yamp;"\
			/*"   if(b<0.0) b+=1.0; else if(b>1.0) b-=1.0;"\*/
			"	gl_FragColor = texture2D(tex, vec2(a,b)) * col;"\
			/*"   if(b<0.0 || b>1.0 || a<0.0 || b>1.0) gl_FragColor = vec4(1,0,1,0);"\*/
			"}"\
		};

			// *** Chrome sheideri
			// 
		static const char *chromeFragment ={
			"uniform sampler2D tex;"\
			/*vahvuus*/
			"uniform int times;"\
			"void main()"\
			"{"\
			" vec4 col = texture2D(tex, gl_TexCoord[0].xy);"\
			" col.r = abs(sin( (3.14159*col.r) ));"\
			" col.g = abs(sin( (3.14159*col.g) ));"\
			" col.b = abs(sin( (3.14159*col.b) ));"\
			" gl_FragColor = col;"\
			"}"\
		};

			// *** Metafake sheideri
			// 
		static const char *metaFragment ={
			"uniform sampler2D tex;"\
			/*vahvuus*/
			"uniform int times;"\
			"void main()"\
			"{"\
			" vec4 c = texture2D(tex, gl_TexCoord[0].xy);"\
			/*" vec4 col = vec4( abs(sin( (3.14159*c.b) ))*1.0 );"\*/
			" vec4 col = vec4( abs(sin( (3.14159*c.b) ))*1.0 );"\
			/*" float f = sin( (3.14159*col.b);"\
			" col = vec4( abs( f ))*0.7 );"\*/
			/*" col.a = 1.0;"\*/
			" col.r *= 0.345;"\
			" col.g *= 0.56;"\
			" col.b *= 0.79;"\
			" col.a = c.r > 0.0 ? 1.0 : 0.0;"\
			" gl_FragColor = col;"\
			"}"\
		};
			// *** Saturate/Brightness/Contrast
			// 
		static const char *colorFragment = {
			"uniform sampler2D tex;"\
			"const vec3 c_ch = vec3(1.0,1.0,1.0);"\
			"uniform float saturate;"\
			"uniform float brightness;"\
			"uniform float contrast;"\
			"void main()"\
			"{"\
			"	vec3 color = texture2D(tex, gl_TexCoord[0].xy).rgb;"\
			"	float x = sqrt(dot(color,color));"\
			"	color.r = pow(color.r+0.01,saturate);"\
			"	color.g = pow(color.g+0.01,saturate);"\
			"	color.b = pow(color.b+0.01,saturate);"\
			"	gl_FragColor.xyz = clamp(0.866 + contrast*(x-0.866),0.05, 1.73)*normalize(color*c_ch)*brightness;"\
			"}"
		};

			// *** Shadow mapping
			//
		static const char *shadowMapVertex = {
			"varying vec4 shadowCoord;"\
			"void main (void)"\
			"{"\
			"   gl_Position = ftransform();"\
			/* shadow texture coordinates generation */
			"   shadowCoord = gl_TextureMatrix[0] * gl_ModelViewMatrix * gl_Vertex;"\
			"}"\
		};

		static const char *shadowMapFragment = {
			"uniform sampler2DShadow shadowMap;"\
			"varying vec4 shadowCoord;"\
			"void main(void)"\
			"{"\
			/* pick 1|0 from projected shadow map */
			"   gl_FragColor = shadow2DProj(shadowMap, shadowCoord).r * vec4(1,1,1,1);"\
			"}"\
		};

			// *** Shadow mapping with texture
			//
		static const char *shadowMapTexVertex = {
			"varying vec4 shadowCoord;"\
			"varying vec2 texCoord;"\
			"varying vec4 ccc;"\
			"void main (void)"\
			"{"\
			"   gl_Position = ftransform();"\
			"   texCoord = gl_MultiTexCoord0.xy;"\
			"	ccc = gl_Color;"\
			/* shadow texture coordinates generation */
			"   shadowCoord = gl_TextureMatrix[0] * gl_ModelViewMatrix * gl_Vertex;"\
			"}"\
		};

		static const char *shadowMapTexFragment = {
			"varying vec2 texCoord;"\
			"varying vec4 ccc;"\
			"varying vec4 shadowCoord;"\
			"uniform sampler2D texture0;"\
			"uniform sampler2DShadow shadowMap;"\
			"void main(void)"\
			"{"\
			/* pick 1|0 from projected shadow map */
			"   gl_FragColor = shadow2DProj(shadowMap, shadowCoord).r * texture2D(texture0, texCoord) * ccc ;"\
			"}"\
		};

			// *** Vesieffu
			// [orange bookin pohjat]
			// Ylemmss fade out
		static const char *waterReflVertex = {
			"varying vec4 waterTex0;"\
			"varying vec4 waterTex1;"\
			"varying vec4 waterTex2;"\
			"varying vec4 waterTex3;"\
			"varying vec4 waterTex4;"\
			"varying vec2 texCoord;"\
			"uniform vec4 viewpos, lightpos;"\
			"uniform float time, time2;"\
			""\
			"void main(void)"\
			"{"\
			"vec4 mpos, temp;"\
			/*Our planes normal is y = 1 -> TNB are easy to get*/
			"vec4 tangent = vec4(1.0, 0.0, 0.0, 0.0);"\
			"vec4 norm = vec4(0.0, 1.0, 0.0, 0.0);"\
			"vec4 binormal = vec4(0.0, 0.0, 1.0, 0.0);"\
			""\
			"mat4 mvp = gl_ModelViewProjectionMatrix;"\
			"mat4 mtx = gl_TextureMatrix[0];"\
			""\
			/*proj*/
			"temp = viewpos - gl_Vertex;"\
			"waterTex4.x = dot(temp, tangent);"\
			"waterTex4.y = dot(temp, binormal);"\
			"waterTex4.z = dot(temp, norm);"\
			"waterTex4.w = 0.0;"\
			""\
			/*light*/
			"temp = lightpos - gl_Vertex;"\
			"waterTex0.x = dot(temp, tangent);"\
			"waterTex0.y = dot(temp, binormal);"\
			"waterTex0.z = dot(temp, norm);"\
			"waterTex0.w = 0.0;"\
			""\
			"mpos = mvp * gl_Vertex;"\
			""\
			"vec4 t1 = vec4(0.0, -time, 0.0,0.0);"\
			"vec4 t2 = vec4(0.0, -time2, 0.0,0.0);"\
			""\
			"texCoord = gl_MultiTexCoord1.xy;"\
			"waterTex1 = gl_MultiTexCoord1 + t1;"\
			"waterTex2 = gl_MultiTexCoord2 + t2;"\
			""\
			"waterTex3 = mpos;"\
			""\
			"gl_Position = ftransform();"\
			"}"\
		};

		static const char *waterReflFragment = {
			
			"uniform sampler2D water_normalmap;"\
			"uniform sampler2D water_reflection;"\
			"uniform sampler2D water_refraction;"\
			"uniform sampler2D water_dudvmap;"\
			"uniform sampler2D water_depthmap;"\
			"uniform sampler2D water_envmap;"\
			"uniform vec4 waterColor;"\
			"uniform float fade;"\
			"varying vec2 texCoord;"\
			""\
			"varying vec4 waterTex0;/*lightpos*/"\
			"varying vec4 waterTex1;/*moving texcoords*/"\
			"varying vec4 waterTex2;/*moving texcoords*/"\
			"varying vec4 waterTex3;/*for projection*/"\
			"varying vec4 waterTex4;/*viewts*/"\
			""\
			"void main(void)"\
			"{"\
			"const vec4 sca = vec4(0.005, 0.005, 0.005, 0.005);"\
			"const vec4 sca2 = vec4(0.02, 0.02, 0.02, 0.02);"\
			"const vec4 tscale = vec4(0.25, 0.25, 0.25, 0.25);"\
			"const vec4 two = vec4(2.0, 2.0, 2.0, 1.0);"\
			"const vec4 mone = vec4(-1.0, -1.0, -1.0, 1.0);"\
			""\
			"const vec4 ofive = vec4(0.5,0.5,0.5,1.0);"\
			""\
			"const float exponent = 64.0;"\
			""\
			/*dudvdist*/
			"vec4 lightTS = normalize(waterTex0);"\
			"vec4 viewt = normalize(waterTex4);"\
			"vec4 disdis = texture2D(water_dudvmap, vec2(waterTex2 * tscale));"\
			"vec4 dist = texture2D(water_dudvmap, vec2(waterTex1 + disdis*sca2));"\
			"vec4 fdist = dist;"\
			"fdist = fdist * two + mone;"\
			"fdist = normalize(fdist);"\
			"fdist *= sca;"\
			""\
			/*load normalmap*/
			"vec4 nmap = texture2D(water_normalmap, vec2(waterTex1 + disdis*sca2));"\
			"nmap = (nmap-ofive) * two;"\
			"vec4 vNorm = nmap;"\
			"vNorm = normalize(nmap);"\
			""\
			/*proj. texcoords*/
			"vec4 tmp = vec4(1.0 / waterTex3.w);"\
			"vec4 temp = tmp;"\
			""\
			"vec4 projCoord = waterTex3 * tmp;"\
			"projCoord += vec4(1.0);"\
			"projCoord *= vec4(0.5);"\
			"tmp = projCoord + fdist;"\
			"tmp = clamp(tmp, 0.001, 0.999);"\
			""\
			/*reflection,refraction and depth texture*/
			"vec4 refTex = texture2D(water_reflection, vec2(tmp));"\
			"vec4 refl = refTex;"\
			"vec4 refr = texture2D(water_refraction, vec2(tmp));"\
			"vec4 wdepth = texture2D(water_depthmap, vec2(tmp));"\
			""\
			"wdepth = vec4(pow(wdepth.x, 4.0));"\
			"vec4 invdepth = 1.0 - wdepth;"\
			/*calculate fresnel and inverted fresnel*/
			"vec4 invfres = vec4( dot(vNorm, viewt) );"\
			"vec4 fres = vec4(1.0) -invfres ;"\
			""\
			/*calculate reflection and refraction*/
			"refr *= invfres;"\
			"refr *= invdepth;"\
			"temp = waterColor * wdepth * invfres;"\
			"refr += temp;"\
			"refl *= fres;"\
			""\
			/*add reflection and refraction*/
			"tmp = refr + refl;"\
			""\
			"gl_FragColor = vec4(tmp.x, tmp.y, tmp.z, waterColor.a) * texture2D(water_envmap, texCoord).r;"\
			"}"\
		};

	
			// *** Lightrays
			//
		static const char *lightrayVertex = {
			"varying vec4 shadowCoord;"\
			"void main (void)"\
			"{"\
			/* shadow texture coordinates generation */
			"   shadowCoord = gl_TextureMatrix[0] * gl_ModelViewMatrix * gl_Vertex;"\
			"   gl_Position = ftransform();"\
			"}"\
		};

		static const char *lightrayFragment = {
			"uniform sampler2D caustic;"\
			"uniform sampler2DShadow shadowMap;"\
			"varying vec4 shadowCoord;"\
			"void main(void)"\
			"{"\
			/* pick 1|0 from projected shadow map */
			/*"  gl_FragColor = texture2DProj(caustic, shadowCoord*14.0) * shadow2DProj(shadowMap, shadowCoord).r * vec4(0.1065, 0.1065, 0.090565, 1);"\*/
			"  gl_FragColor = texture2DProj(caustic, shadowCoord*24.0) /* shadow2DProj(shadowMap, shadowCoord).r*/ * vec4(0.102065, 0.102065, 0.1020790565, 1);"\
			"}"\
		};
		// ---------------------------------------------------------------
		// Soft shadows tutorial
		// http://www.gamedev.net/reference/articles/article2193.asp
		// ---------------------------------------------------------------



	dmsMsg("ShaderManager::init() : Initializing shaders\n");

	Shader *mixaa = new Shader();
	mixaa->init("mixaa", mixFragment, mixVertex);
	addShader(mixaa);

	Shader *ground = new Shader();
	ground->init("ground", dmsGetText("ground_frag.glsl"), dmsGetText("ground_vert.glsl"));
	addShader(ground);

	Shader *uppophong = new Shader();
	uppophong->init("uppophong", dmsGetText("uppophong_frag.glsl"), dmsGetText("uppophong_vert.glsl"));
	addShader(uppophong);

	Shader *waterrefl = new Shader();
	waterrefl->init("waterRefl", waterReflFragment, waterReflVertex);
	addShader(waterrefl);

	Shader *lightray = new Shader;
	lightray->init("lightray", lightrayFragment, lightrayVertex);
	addShader(lightray);

	Shader *phong = new Shader;
	phong->init("phong", dmsGetText("phong_frag.glsl"), dmsGetText("phong_vert.glsl"));
	addShader(phong);

	Shader *fishbone = new Shader;
	fishbone->init("fishbone", dmsGetText("fishbone_frag.glsl"), dmsGetText("fishbone_vert.glsl"));
	addShader(fishbone);

	Shader *normal = new Shader;
	normal->init("normal_mapping", dmsGetText("normal_mapping_frag.glsl"), dmsGetText("normal_mapping_vert.glsl"));
	addShader(normal);

	Shader *waternormal = new Shader;
	waternormal->init("water_normal_mapping", dmsGetText("water_normal_mapping_frag.glsl"), dmsGetText("water_normal_mapping_vert.glsl"));
	addShader(waternormal);

	Shader *depths = new Shader();
	depths->init("depth_col_adjust", dmsGetText("depth_col_adjust_frag.glsl"), dmsGetText("depth_col_adjust_vert.glsl"));
	addShader(depths);

	Shader *tyonto = new Shader();
	tyonto->init("tyonto", dmsGetText("tyonto_frag.glsl"), dmsGetText("tyonto_vert.glsl"));
	addShader(tyonto);

	Shader *noises = new Shader();
	noises->init("noise", dmsGetText("noise_frag.glsl"), dmsGetText("noise_vert.glsl"));
	addShader(noises);

	Shader *color = new Shader();
	color->init("color", colorFragment, emptyVertex);
	addShader(color);
	
	Shader *sindistort = new Shader();
	sindistort->init("sindistort", sindistortFragment, sindistortVertex);
	addShader(sindistort);
	
	Shader *chrome = new Shader();
	chrome->init("chrome", chromeFragment, emptyVertex);
	addShader(chrome);

	Shader *meta = new Shader();
	meta->init("meta", metaFragment, emptyVertex);
	addShader(meta);

	Shader *blurx = new Shader();
	blurx->init("blurx", blurFragment, blurxVertex);
	addShader(blurx);

	Shader *blury = new Shader();
	blury->init("blury", blurFragment, bluryVertex);
	addShader(blury);

	Shader *blur2x = new Shader();
	blur2x->init("blur2x", blur2Fragment, blurxVertex);
	addShader(blur2x);

	Shader *blur2y = new Shader();
	blur2y->init("blur2y", blur2Fragment, bluryVertex);
	addShader(blur2y);

	Shader *darken = new Shader();
	darken->init("darken",darkenFragment, darkenVertex);
	addShader(darken);

	Shader *glowc = new Shader();
	glowc->init("glowc", glowcFragment, glowcVertex);
	addShader(glowc);

	Shader *edge = new Shader();
	edge->init("edge", edgeFragment, emptyVertex);
	addShader(edge);

	Shader *invert = new Shader();
	invert->init("invert", invertFragment, invertVertex);
	addShader(invert);
	
	Shader *blackwhite = new Shader();
	blackwhite->init("blackwhite", bwFragment, bwVertex);
	addShader(blackwhite); 

	Shader *dof = new Shader();
	dof->init("dof", dofFragment, dofVertex);
	addShader(dof);
	
	Shader *caustic = new Shader();
	caustic->init("caustic", dmsGetText("caustics_frag.glsl"), dmsGetText("caustics_vert.glsl"));
	addShader(caustic);

	Shader *shadowmap = new Shader();
	shadowmap->init("shadowmap", shadowMapFragment, shadowMapVertex); 
	addShader(shadowmap);

	Shader *shadowmaptex = new Shader();
	shadowmaptex->init("shadowmaptex", shadowMapTexFragment, shadowMapTexVertex); 
	addShader(shadowmaptex);

	Shader *greetwater = new Shader();
	greetwater->init("greetwater", dmsGetText("greetwater_frag.glsl"), dmsGetText("greetwater_vert.glsl")); 
	addShader(greetwater);

	// Nv7xxx version
	Shader *shadowfisu = new Shader();
	if(Config::nv7)
	{
		shadowfisu->init("fisu_shadowmaptex", dmsGetText("fisu_ground_frag_nv7.glsl"), dmsGetText("fisu_ground_vert_nv7.glsl"));
	}
	else
	{
		shadowfisu->init("fisu_shadowmaptex", dmsGetText("fisu_ground_frag.glsl"), dmsGetText("fisu_ground_vert.glsl"));
	}	
	addShader(shadowfisu);


	unbind();

	dmsMsg("ShaderManager::init() : Shaders created\n");
}

void ShaderManager::deInitShaders() 
{
	
	dmsMsg("Deinit shaders(): start\n");
/*
	shadowMapTex->deinit();
	delete shadowMapTex;

	shadowMap->deinit();
	delete shadowMap;

	sindistort->deinit();
	delete sindistort;
	
	chrome->deinit();
	delete chrome;

	blurx->deinit();
	delete blurx;

	blury->deinit();
	delete blury;

	darken->deinit();
	delete darken;

	glowc->deinit();
	delete glowc;

	edge->deinit();
	delete edge;

	blackwhite->deinit();
	delete blackwhite;

	invert->deinit();
	delete invert;
	
	dof->deinit();
	delete dof;
*/
	dmsMsg("ShaderManager::deinit() : Shaders released\n");
}

//--------------------------------------------------------------------------------------------
//  Class code
//--------------------------------------------------------------------------------------------

void ShaderManager::unbind() 
{
	glUseProgramObjectARB(0);
}

ShaderManager::ShaderManager()
{
	nShaders = 0;	
}

ShaderManager::~ShaderManager()
{
}

ShaderManager *ShaderManager::create()
{

	if(!createdFlag)
	{					
		instance = new ShaderManager;
		if(!instance)
		{
			throw "ShaderManager::create(): Memory allocation error";
		}

		instance->initShaders();
		
		createdFlag = true;

		dmsMsg("ShaderManager::create(): ShaderManager instance created\n");
	}

	return instance;
}

void ShaderManager::debug()
{
	shaderList.debug();
}

void ShaderManager::release()
{	
	Node<Shader> *getNode;
	Shader *shader = NULL;

	if(createdFlag)
	{	
		createdFlag = false;
		

		if(instance)
		{
			// Vitun listat.
			instance->nShaders= 0;
			//deInitShaders();
			//instance->shaderList.freeList();
	
			int i;
			for(i = 0; i < instance->nShaders; i++)
			{
				getNode = instance->shaderList.get(i);
				shader = getNode->a;

				if(shader)
				{
					shader->deinit();
					delete shader;
					shader = NULL;
				}
			}

			instance->nShaders = 0;
			//instance->effects.freeList();

			delete instance;
			instance = NULL;
		}

		dmsMsg("ShaderManager::release(): Instance deleted\n");		
	}

}

bool ShaderManager::addShader(Shader *shader)
{
	return addShader(shader->name, shader);
}
bool ShaderManager::addShader(const char *name, Shader *shader)
{
	if(!shader->initialized)
	{
		char buf[250];
		dmsMsg(buf, "Added shader was not initialized: id %s", name);

#ifdef _DEBUG
		MessageBox(0,buf,0,0);
		exit(0);
#endif
	}

	shaderList.addTail(shader, name, 0);
	nShaders++;

	dmsMsg("ShaderManager::addShader(): Shader \"%s\" loaded.\n", name);

	return true;
}

//-------------------------------------------------------
// Getters
//-------------------------------------------------------

unsigned int ShaderManager::getShaderCount()
{
	return nShaders;
}

Shader *ShaderManager::getShader(unsigned int index)
{
	Node<Shader> *getNode = NULL;

	(index > nShaders-1) ? index = nShaders-1 : index = index;
	(index < 0) ? index = 0 : index = index;
	
	getNode = shaderList.get(index);

	if(getNode!=NULL) return getNode->a;

	char buf[250];
	sprintf(buf, "Shader was not found : id %d", index);
	dmsMsg("%s\n", buf);

	MessageBox(0,buf, 0,0);
	exit(0);

	return NULL;
}

Shader *ShaderManager::getShader(char *name)
{
	Node<Shader> *getNode = NULL;
	
	getNode = shaderList.find(name);
	
	if(getNode!=NULL) return getNode->a;

#ifdef _DEBUG
	char buf[400];
	sprintf(buf, "Could not find shader with name\nShaderManager::getShader\n%s", name);
	MessageBox(dmsGetHWND(),
             buf,
             "ERROR",MB_TOPMOST|MB_OK|MB_ICONEXCLAMATION);
#endif
     

	return NULL;
}


//////////////////////////////////////////////
// Shader class 
//////////////////////////////////////////////
void Shader::init(const char *name_, const char *frag, const char *vert) 
{
	if(frag==0 || vert==0)
	{
		  char buf[100];
		  sprintf(buf, "ERROR: couldn't init shader! fragment or vertex shader contents were missing [%s] \n", name_);
#ifdef _DEBUG
		  MessageBox(dmsGetHWND(), buf, name_, MB_OK|MB_TOPMOST);     
#endif
		  dmsMsg("%s", buf);
		return;
	}

	this->name = name_;

	vertex = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);
	glShaderSourceARB(this->vertex, 1, &vert, NULL);
	glCompileShaderARB(this->vertex);
	debugShader(vertex, name_);

	fragment = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);
	glShaderSourceARB(this->fragment, 1, &frag, NULL);
	glCompileShaderARB(this->fragment);
	debugShader(fragment, name_);

	program = glCreateProgramObjectARB();
	glAttachObjectARB(this->program,vertex);
	glAttachObjectARB(this->program,fragment);
	glLinkProgramARB(this->program);
	debugShader(this->program, name_);

	glUseProgramObjectARB(program);
	
	initialized = true;
}

void Shader::initFromFile(const char *name_, char *frag, char *vert) {
  
    // load vertex program
   if (vert == 0)
   { 	  
	  char buf[100];
	  sprintf(buf, "ERROR: couldn't load vertex shader! [%s from %s] \n", name_, vert);
	#ifdef _DEBUG
	  MessageBox(dmsGetHWND(), buf, name_, MB_OK|MB_TOPMOST);     
	#endif
      dmsMsg("ERROR: couldn't load vertex shader [%s from %s]\n", name_, vert);
   }

  
  // Load fragment program
  if (frag == 0)
  {
	  //memset(fr,' ',10000);
      dmsMsg("ERROR: couldn't load fragment shader [%s from %s]\n", name_, frag);
	  char buf[100];
	  sprintf(buf, "ERROR: couldn't load vertex shader! [%s from %s]\n", name_, frag);
	#ifdef _DEBUG
	  MessageBox(dmsGetHWND(), buf, name_, MB_OK|MB_TOPMOST);
	#endif

  }

  init(name_ , frag, vert);
}



char *Shader::loadFromFile(char *filename) 
{

	char tmpLine[256] = {0};
	int count = 0;

	std::fstream f;
	f.open(filename, std::ios::in|std::ios::binary);

	if (!f.is_open() || !f.good())
	{
		MessageBox(dmsGetHWND(), filename, "Failed to load file ; sizetest", MB_OK|MB_TOPMOST);
		dmsMsg("ERROR: Failed to load ; sizetest %s\n", filename);
		return false;
	}

	while(!f.eof())
    {
		f.getline(tmpLine, 256, '\n');
        count++;
	}

	f.close();

	if(count == 0) return 0;
	if (!f.is_open() || !f.good())
	{

	}


   // Read in the data for use this time.
   ifstream input;

   // Create array to hold shader code.
   char *src = new char[256 * count];

   // Re-open the shader and read in the whole thing into the array.
   input.open(filename);
	
   if(!input.is_open() || !input.good())
   {
		MessageBox(dmsGetHWND(), filename, "Failed to load file ; input", MB_OK|MB_TOPMOST);
		dmsMsg("ERROR: Failed to load ; input %s\n", filename);
		return false;
   }

   input.getline(src , 256 * count, '\0');

   input.close(); // Close the shader.

   return src;
}

void Shader::deinit() 
{
		glDeleteShader(vertex);
		glDeleteShader(fragment);
		glDeleteProgram(program);
		initialized = false;
}

void Shader::bind() 
{
		glUseProgramObjectARB(this->program);
}

void Shader::unbind() 
{
		glUseProgramObjectARB(0);
}

////////////////////////////////////////////////////////////////
// PARAMETER PASSING 
////////////////////////////////////////////////////////////////

bool Shader::setUniform1f(char* varname, GLfloat v0)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform1fARB(loc, v0);
    
    return true;
}

bool Shader::setUniform2f(char* varname, GLfloat v0, GLfloat v1)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform2fARB(loc, v0, v1);
    
    return true;
}

bool Shader::setUniform3f(char* varname, GLfloat v0, GLfloat v1, GLfloat v2)
{
    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform3fARB(loc, v0, v1, v2);

    return true;
}

bool Shader::setUniform4f(char* varname, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform4fARB(loc, v0, v1, v2, v3);

    return true;
}

bool Shader::setUniform1i(char* varname, GLint v0)
{ 


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform1iARB(loc, v0);
    
    return true;
}
bool Shader::setUniform2i(char* varname, GLint v0, GLint v1)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform2i(loc, v0, v1);


    return true;
}

bool Shader::setUniform3i(char* varname, GLint v0, GLint v1, GLint v2)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform3i(loc, v0, v1, v2);

    return true;
}
bool Shader::setUniform4i(char* varname, GLint v0, GLint v1, GLint v2, GLint v3)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform4i(loc, v0, v1, v2, v3);

    return true;
}

bool Shader::setUniform1fv(char* varname, GLsizei count, GLfloat *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform1fv(loc, count, value);

    return true;
}
bool Shader::setUniform2fv(char* varname, GLsizei count, GLfloat *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform2fv(loc, count, value);

    return true;
}

bool Shader::setUniform3fv(char* varname, GLsizei count, GLfloat *value)
{

    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform3fv(loc, count, value);

    return true;
}

bool Shader::setUniform4fv(char* varname, GLsizei count, GLfloat *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform4fv(loc, count, value);

    return true;
}

bool Shader::setUniform1iv(char* varname, GLsizei count, GLint *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform1iv(loc, count, value);

    return true;
}

bool Shader::setUniform2iv(char* varname, GLsizei count, GLint *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform2iv(loc, count, value);

    return true;
}

bool Shader::setUniform3iv(char* varname, GLsizei count, GLint *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform3iv(loc, count, value);

    return true;
}

bool Shader::setUniform4iv(char* varname, GLsizei count, GLint *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniform4iv(loc, count, value);

    return true;
}

bool Shader::setUniformMatrix2fv(char* varname, GLsizei count, GLboolean transpose, GLfloat *value)
{    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniformMatrix2fv(loc, count, transpose, value);

    return true;
}

bool Shader::setUniformMatrix3fv(char* varname, GLsizei count, GLboolean transpose, GLfloat *value)
{


    
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniformMatrix3fv(loc, count, transpose, value);

    return true;
}

bool Shader::setUniformMatrix4fv(char* varname, GLsizei count, GLboolean transpose, GLfloat *value)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
    
    glUniformMatrix4fv(loc, count, transpose, value);

    return true;
}

GLint Shader::GetUniLoc(const GLcharARB *name)
{
	GLint loc;

	loc = glGetUniformLocationARB(this->program, name);
	if (loc == -1) 
	{
        dmsMsg("ERROR: can't find uniform variable %s from %s\n", name, this->name);

	}
	return loc;
}

void Shader::GetUniformfv(char* name, GLfloat* values)
{
    GLint loc;

	loc = glGetUniformLocationARB(this->program, name);
	if (loc == -1) 
	{
		dmsMsg("ERROR: can't find uniform variable %s \n", name);
	}
	glGetUniformfvARB(this->program, loc, values);
	
}

void Shader::GetUniformiv(char* name, GLint* values)
{
    GLint loc;

	loc = glGetUniformLocationARB(this->program, name);
	if (loc == -1) 
	{
        dmsMsg("ERROR: can't find uniform variable %s \n", name);
	}
	
	glGetUniformivARB(this->program, loc, values);

}

bool Shader::setVertexAttrib1f(char *varname, GLfloat v0)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
   glVertexAttrib1f(loc, v0);

   return true;
}

bool Shader::setVertexAttrib2f(char *varname, GLfloat v0, GLfloat v1)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable
   glVertexAttrib2f(loc, v0, v1);
   
   return true;
}

bool Shader::setVertexAttrib3f(char *varname, GLfloat v0, GLfloat v1, GLfloat v2)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable   
    glVertexAttrib3f(loc, v0, v1, v2);
    
    return true;
}

bool Shader::setVertexAttrib4f(char *varname, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    GLint loc = GetUniLoc(varname);
    if (loc==-1) return false;  // can't find variable

   glVertexAttrib4f(loc, v0, v1, v2, v3);
   
   return true;
}

////////////////////////////////////////////////////////////
// Debug global
////////////////////////////////////////////////////////////

void debugShader(GLuint obj, const char *name)
{
	int infologLength = 0;
	char infoLog[1024];
 
	if (glIsShader(obj))  
	{
		glGetShaderInfoLog(obj, 1024, &infologLength, infoLog);
		if(infologLength>0) 
		{
#ifdef _DEBUG
			MessageBox(dmsGetHWND(), infoLog, name, MB_OK|MB_TOPMOST);		
#endif
			dmsMsg("%s, %s", name, infoLog);
		}

	}
	else  
	{
		glGetProgramInfoLog(obj, 1024, &infologLength, infoLog);
		
		if(infologLength>0) 
		{
			dmsMsg("%s, %s", name, infoLog);
		}
	}	
		
}	
