#ifndef _LISTA_HPP_
#define _LISTA_HPP_

//--------------------------------------------------------------------------------------------
//  This code belongs to our library namespace: TRACTION_DEMOTRACTOR
//--------------------------------------------------------------------------------------------

namespace TRACTION_DEMOTRACTOR
{

//--------------------------------------------------------------------------------------------
//  ListanSolmu class
//--------------------------------------------------------------------------------------------

	class ListanSolmu
	{
		public:

			//muodostimet ja tuhoajat
			ListanSolmu();
			ListanSolmu(void *ptr);
			~ListanSolmu();

			//asettaa solmun datan halutuksi
			void set(void *ptr);

			//tulostaa tiedot
			void print();

			//osoittimet seuraaviin osiin
			class ListanSolmu *next;
			class ListanSolmu *previous;

			//data, jota solmu kantaa
			void *payload;

	};

//--------------------------------------------------------------------------------------------
//  Listan class
//--------------------------------------------------------------------------------------------

	class __declspec(dllexport) Lista
	{
		public:

			Lista();
			~Lista();
			
			//listn listan loppuun alkio (onnistuu aina)
			void add(void *dataptr);
			//poistetaan listan viimeinen alkio (palauttaa false jos lista on tyhj)
			bool removeLast();
			//listn typointterin jlkeen alkio (palauttaa false jos typointteri ei ole kelvollinen)
			bool insert(void *dataptr);
			//poistetaan alkio typointterin kohdalta
			bool remove();

			//tuhotaan koko lista ja vapautetaan kaikki tiedot
			void destroy();

			//asettaa typointterin listan alkuun (palauttaa false jos lista on tyhj)
			bool goToStart();
			//asettaa typointterin listan loppuun (palauttaa false jos lista on tyhj)
			bool goToEnd();
			//liikuttaa typointteria eteenpin (palauttaa false jos lista on loppu)
			bool goForward();
			//liikuttaa typointteria taaksepin (palauttaa false jos ollaan alussa)
			bool goBackwards();
			//menee haluttuun nodeen (palauttaa false jos ei onnistu)
			bool goToNode(int number); 

			//tutkii, ollaanko ekassa nodessa
			bool isAtEnd();
			//tutkii, ollaanko vikassa nodessa
			bool isAtStart();

			//antaa ensimmisen noden osoittaman tiedon
			void *getFirst();
			//antaa viimeisen noden osoittaman tiedon
			void *getLast();
			//antaa typointterin osoittaman tiedon
			void *getCurrent();
			//asettaa typointterin nodeen uuden tiedon (tuhoaa vanhan jos siell sellaista on)
			void setCurrent(void *ptr);
			//kertoo kuinka monta solmua listassa on
			int getNodeCount();
			//kertoo nykyisen noden
			int getCurrentNodeNumber();

			//tulostetaan lista lokiin (debug)
			void print();

		private:

			int solmuja;
			ListanSolmu *start;
			ListanSolmu *current;
			ListanSolmu *end;
	};
}

#endif