/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;

public class AddDebugToCallStackNode
extends AsmNode {
    private DebugInfo debug;
    private AsmNode body;

    public AddDebugToCallStackNode(DebugInfo debugInfo, AsmNode asmNode) {
        this.debug = debugInfo;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        return new AddDebugToCallStackNode(this.debug, this.body);
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        evaluationState.getCallStack().push(this.debug);
        this.body.parse(evaluationState);
        evaluationState.getCallStack().pop();
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.getCallStack().push(this.debug);
        this.body.parse(evaluationState);
        evaluationState.getCallStack().pop();
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        evaluationState.getCallStack().push(this.debug);
        this.body.preParse(evaluationState);
        evaluationState.getCallStack().pop();
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        evaluationState.getCallStack().push(this.debug);
        this.body.registerMetaDefinitions(evaluationState);
        evaluationState.getCallStack().pop();
        return this;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("AddDebugToCallStack", this.debug);
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

