/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SEPrintNow;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import cml.log.Log;

public class PrintNowDirective
extends Directive {
    private static Log log = new Log("");
    private static final String indent = "   ";
    private ExprNode msgExpr;

    public PrintNowDirective(ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.msgExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.msgExpr.evaluate(evaluationState);
        String string = indent + value.getString(this.debug);
        log.println(string);
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        evaluationState.addSideEffect(new SEPrintNow(string));
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        Value value = this.msgExpr.evaluate(evaluationState);
        String string = indent + value.getString(this.debug);
        log.println(string);
        evaluationState.addSideEffect(new SEPrintNow(string));
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("PrintNow", this.debug, this.msgExpr);
        return nodeTreeBuilder;
    }
}

