/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.EntityScope;

public class MacroDefinition
extends AsmDirective {
    private String name;
    private ExecutableDirectives macro;

    public MacroDefinition(String string, ExecutableDirectives executableDirectives, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.macro = executableDirectives;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) throws AsmException {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        EntityScope<ExecutableDirectives> entityScope = evaluationState.getCurrentScope().getMacros();
        if (entityScope.getLocalDefinedEntities().containsKey(this.name)) {
            throw new AsmError("The macro '" + this.name + "'  is already defined", this.debug);
        }
        entityScope.put(this.name, this.macro);
        return EmptyOutput.instance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("MacroDef", this.debug);
        nodeTreeBuilder.addArg("name", this.name);
        int n = 0;
        for (String object : this.macro.getArgumentNames()) {
            nodeTreeBuilder.addArg("arg" + ++n, object);
        }
        for (AsmNode asmNode : this.macro.getDirectives()) {
            nodeTreeBuilder.addArg(null, asmNode);
        }
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

