/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.AbstractLibrary;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BinaryFileValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.PictureValue;
import cml.kickass.values.SidFileValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class MiscLibrary
extends AbstractLibrary {
    public List<Constant> getConstants() {
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        arrayList.add(new Constant("BLACK", new NumberValue(0.0)));
        arrayList.add(new Constant("WHITE", new NumberValue(1.0)));
        arrayList.add(new Constant("RED", new NumberValue(2.0)));
        arrayList.add(new Constant("CYAN", new NumberValue(3.0)));
        arrayList.add(new Constant("PURPLE", new NumberValue(4.0)));
        arrayList.add(new Constant("GREEN", new NumberValue(5.0)));
        arrayList.add(new Constant("BLUE", new NumberValue(6.0)));
        arrayList.add(new Constant("YELLOW", new NumberValue(7.0)));
        arrayList.add(new Constant("ORANGE", new NumberValue(8.0)));
        arrayList.add(new Constant("BROWN", new NumberValue(9.0)));
        arrayList.add(new Constant("LIGHT_RED", new NumberValue(10.0)));
        arrayList.add(new Constant("DARK_GRAY", new NumberValue(11.0)));
        arrayList.add(new Constant("DARK_GREY", new NumberValue(11.0)));
        arrayList.add(new Constant("GRAY", new NumberValue(12.0)));
        arrayList.add(new Constant("GREY", new NumberValue(12.0)));
        arrayList.add(new Constant("LIGHT_GREEN", new NumberValue(13.0)));
        arrayList.add(new Constant("LIGHT_BLUE", new NumberValue(14.0)));
        arrayList.add(new Constant("LIGHT_GRAY", new NumberValue(15.0)));
        arrayList.add(new Constant("LIGHT_GREY", new NumberValue(15.0)));
        arrayList.add(new Constant("BF_C64FILE", new StringValue("C64FILE")));
        arrayList.add(new Constant("BF_KOALA", new StringValue("C64FILE, Bitmap=$0000, ScreenRam=$1f40, ColorRam=$2328, BackgroundColor = $2710")));
        arrayList.add(new Constant("BF_FLI", new StringValue("C64FILE, ColorRam=$0000, ScreenRam=$0400, Bitmap=$2400")));
        arrayList.add(new Constant("BF_BITMAP_SINGLECOLOR", new StringValue("C64FILE, Bitmap=$0000, ScreenRam=$2000")));
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function("LoadSid", 1, SidFileValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return MiscLibrary.loadSid(evaluationState, valueArray, debugInfo);
            }
        });
        arrayList.add(new Function("LoadPicture", null, PictureValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return MiscLibrary.loadPicture(evaluationState, valueArray, debugInfo);
            }
        });
        arrayList.add(new Function("LoadBinary", null, BinaryFileValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return MiscLibrary.loadBinary(evaluationState, valueArray, debugInfo);
            }
        });
        return arrayList;
    }

    private static Value loadSid(EvaluationState evaluationState, Value[] valueArray, DebugInfo debugInfo) {
        int n;
        String string = valueArray[0].getString(debugInfo);
        InputStream inputStream = evaluationState.openFile(string, debugInfo);
        byte[] byArray = new byte[65536];
        try {
            n = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new AsmError("Error while reading file '" + string + "'", debugInfo);
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
        return new SidFileValue(byArray2, debugInfo);
    }

    private static Value loadPicture(EvaluationState evaluationState, Value[] valueArray, DebugInfo debugInfo) throws AsmException {
        Object object;
        if (valueArray.length < 1 || 2 < valueArray.length) {
            throw new AsmError("Invalid number of arguments", debugInfo);
        }
        String string = valueArray[0].getString(debugInfo);
        File file = evaluationState.getFile(string, debugInfo);
        int[] nArray = null;
        if (valueArray.length > 1) {
            object = valueArray[1].getList(debugInfo);
            nArray = new int[((ArrayList)object).size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((Value)((ArrayList)object).get(i)).getInt(debugInfo);
            }
        }
        object = null;
        try {
            object = ImageIO.read(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object == null) {
            throw new AsmError("Couldnt load image file '" + string + "'", debugInfo);
        }
        try {
            MediaTracker mediaTracker = new MediaTracker(new JPanel());
            mediaTracker.addImage((Image)object, 0);
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            throw new AsmError("Error while loading image file '" + string + "'", debugInfo);
        }
        int n = ((BufferedImage)object).getWidth(null);
        int n2 = ((BufferedImage)object).getHeight(null);
        int[] nArray2 = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber((Image)object, 0, 0, n, n2, nArray2, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            new AsmError("Error while grapping pixels: " + exception.getMessage(), debugInfo);
        }
        return new PictureValue(n, n2, nArray2, nArray);
    }

    private static Value loadBinary(EvaluationState evaluationState, Value[] valueArray, DebugInfo debugInfo) throws AsmException {
        int n;
        if (valueArray.length < 1 || 2 < valueArray.length) {
            throw new AsmError("Invalid number of arguemnts", debugInfo);
        }
        String string = valueArray[0].getString(null);
        InputStream inputStream = evaluationState.openFile(string, debugInfo);
        byte[] byArray = new byte[0x100000];
        try {
            n = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new AsmError("Error while reading file '" + string + "'", debugInfo);
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
        String string2 = "";
        if (valueArray.length >= 2) {
            string2 = valueArray[1].getString(debugInfo);
        }
        BinaryFileValue.BlockData blockData = BinaryFileValue.templateToBlocks(string2, byArray2.length, debugInfo);
        return new BinaryFileValue(byArray2, blockData);
    }
}

