/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.directives.asmmode.UserFunction;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;

public class FunctionDeclerationDirective
extends AsmDirective {
    private String name;
    private ExecutableDirectives function;

    public FunctionDeclerationDirective(String string, ExecutableDirectives executableDirectives, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.function = executableDirectives;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        UserFunction userFunction = new UserFunction(this.name, this.function);
        evaluationState.getFunctionTable().add(userFunction);
        return EmptyOutput.instance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("FunctionDec", this.debug);
        nodeTreeBuilder.addArg("name", this.name);
        int n = 0;
        for (String object : this.function.getArgumentNames()) {
            nodeTreeBuilder.addArg("arg" + ++n, object);
        }
        for (AsmNode asmNode : this.function.getDirectives()) {
            nodeTreeBuilder.addArg(null, asmNode);
        }
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

