/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.MultiLabelReferenceValue;
import cml.kickass.values.NumberValue;

public class MultiLabelDirective
extends AsmDirective {
    private String name;
    private Integer multiLabelIndex;

    public MultiLabelDirective(String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
    }

    @Override
    public AsmNode copy() {
        return new MultiLabelDirective(this.name, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        MultiLabelReferenceValue multiLabelReferenceValue = (MultiLabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        multiLabelReferenceValue.setMultiLabelIndex(this.multiLabelIndex, evaluationState);
        Integer n = evaluationState.getMemoryPosition();
        if (n == null) {
            return this;
        }
        NumberValue numberValue = new NumberValue(n.intValue());
        multiLabelReferenceValue.setResolvedLabelValue(numberValue, evaluationState, this.debug);
        evaluationState.setMadeMetaProgress();
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        MultiLabelReferenceValue multiLabelReferenceValue = (MultiLabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (multiLabelReferenceValue == null) {
            multiLabelReferenceValue = new MultiLabelReferenceValue();
            symbolScope.put(this.name, multiLabelReferenceValue);
        }
        this.multiLabelIndex = multiLabelReferenceValue.addMultiLabel();
        return this;
    }

    @Override
    public String toString() {
        return "MultiLabel(" + this.name + ")";
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("MultiLabelDir", this.debug, "" + this.multiLabelIndex, new ExprNode[0]);
        return nodeTreeBuilder;
    }
}

