/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.EntityScope;

public class PseudoCommandDefinition
extends AsmDirective {
    private String name;
    private ExecutableDirectives pseudoCmd;

    public PseudoCommandDefinition(String string, ExecutableDirectives executableDirectives, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.pseudoCmd = executableDirectives;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) throws AsmException {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) throws AsmException {
        EntityScope<ExecutableDirectives> entityScope = evaluationState.getCurrentScope().getPseudoCommands();
        if (entityScope.getLocalDefinedEntities().containsKey(this.name)) {
            throw new AsmError("The pseudo command '" + this.name + "'  is already defined", this.debug);
        }
        entityScope.put(this.name, this.pseudoCmd);
        return EmptyOutput.instance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("PseudoCmdDef", this.debug);
        nodeTreeBuilder.addArg("name", this.name);
        int n = 0;
        for (String object : this.pseudoCmd.getArgumentNames()) {
            nodeTreeBuilder.addArg("arg" + ++n, object);
        }
        for (AsmNode asmNode : this.pseudoCmd.getDirectives()) {
            nodeTreeBuilder.addArg(null, asmNode);
        }
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

